/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.protocol.http.sampler.SoapSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class SoapSamplerGui
extends AbstractSamplerGui {
    private static final String label = JMeterUtils.getResString((String)"soap_sampler_title");
    JLabeledTextField urlField = new JLabeledTextField(JMeterUtils.getResString((String)"url"));
    JLabeledTextArea soapXml = new JLabeledTextArea(JMeterUtils.getResString((String)"soap_data_title"), null);

    public SoapSamplerGui() {
        this.init();
    }

    public String getStaticLabel() {
        return label;
    }

    public TestElement createTestElement() {
        SoapSampler sampler = new SoapSampler();
        this.configureTestElement((TestElement)sampler);
        try {
            URL url = new URL(this.urlField.getText());
            sampler.setDomain(url.getHost());
            sampler.setPort(url.getPort());
            sampler.setProtocol(url.getProtocol());
            sampler.setMethod("POST");
            sampler.setPath(url.getPath());
            sampler.setXmlData(this.soapXml.getText());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return sampler;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(label);
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        mainPanel.add((Component)this.urlField);
        mainPanel.add((Component)this.soapXml);
        this.add(mainPanel);
    }

    public void configure(TestElement el) {
        super.configure(el);
        SoapSampler sampler = (SoapSampler)el;
        try {
            this.urlField.setText(sampler.getUrl().toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.soapXml.setText(sampler.getXmlData());
    }
}

