/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AuthPanel
extends AbstractConfigGui
implements ActionListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    InnerTableModel tableModel = new InnerTableModel();
    JTable authTable;
    JButton addButton;
    JButton deleteButton;
    JButton loadButton;
    JButton saveButton;
    JPanel authManagerPanel;

    public AuthPanel() {
        this.init();
    }

    public TestElement createTestElement() {
        AuthManager authMan = this.tableModel.manager;
        this.configureTestElement((TestElement)authMan);
        return (TestElement)authMan.clone();
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.tableModel.manager = (AuthManager)el;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"auth_manager_title");
    }

    public void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2));
        this.authManagerPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.authManagerPanel.setBorder(margin);
        this.authManagerPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"auth_manager_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        this.authManagerPanel.add(panelTitleLabel);
        this.authManagerPanel.add((Component)this.getNamePanel());
        JPanel authTablePanel = this.createAuthTablePanel();
        this.authManagerPanel.add(authTablePanel);
        this.add(this.authManagerPanel);
    }

    public void actionPerformed(ActionEvent e) {
        block24: {
            String action = e.getActionCommand();
            if (action.equals("Delete")) {
                if (this.tableModel.getRowCount() > 0) {
                    int rowSelected;
                    if (this.authTable.isEditing()) {
                        TableCellEditor cellEditor = this.authTable.getCellEditor(this.authTable.getEditingRow(), this.authTable.getEditingColumn());
                        cellEditor.cancelCellEditing();
                    }
                    if ((rowSelected = this.authTable.getSelectedRow()) != -1) {
                        this.tableModel.removeRow(rowSelected);
                        this.tableModel.fireTableDataChanged();
                        if (this.tableModel.getRowCount() == 0) {
                            this.deleteButton.setEnabled(false);
                            this.saveButton.setEnabled(false);
                        } else {
                            int rowToSelect = rowSelected;
                            if (rowSelected >= this.tableModel.getRowCount()) {
                                rowToSelect = rowSelected - 1;
                            }
                            this.authTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                        }
                    }
                }
            } else if (action.equals("Add")) {
                if (this.authTable.isEditing()) {
                    TableCellEditor cellEditor = this.authTable.getCellEditor(this.authTable.getEditingRow(), this.authTable.getEditingColumn());
                    cellEditor.stopCellEditing();
                }
                this.tableModel.addNewRow();
                this.tableModel.fireTableDataChanged();
                if (!this.deleteButton.isEnabled()) {
                    this.deleteButton.setEnabled(true);
                }
                if (!this.saveButton.isEnabled()) {
                    this.saveButton.setEnabled(true);
                }
                int rowToSelect = this.tableModel.getRowCount() - 1;
                this.authTable.setRowSelectionInterval(rowToSelect, rowToSelect);
            } else if (action.equals("Load")) {
                try {
                    File tmp = FileDialoger.promptToOpenFile().getSelectedFile();
                    if (tmp == null) break block24;
                    this.tableModel.manager.addFile(tmp.getAbsolutePath());
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() > 0) {
                        this.deleteButton.setEnabled(true);
                        this.saveButton.setEnabled(true);
                    }
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {}
            } else if (action.equals("Save")) {
                try {
                    File tmp = FileDialoger.promptToSaveFile(null).getSelectedFile();
                    if (tmp != null) {
                        this.tableModel.manager.save(tmp.getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
            }
        }
    }

    public JPanel createAuthTablePanel() {
        EmptyBorder margin = new EmptyBorder(5, 10, 10, 10);
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout((LayoutManager)new VerticalLayout(0, 0));
        tempPanel.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"auths_stored")), margin));
        this.authTable = new JTable(this.tableModel);
        this.authTable.setCellSelectionEnabled(true);
        this.authTable.setRowSelectionAllowed(true);
        this.authTable.setColumnSelectionAllowed(false);
        this.authTable.setSelectionMode(0);
        TableColumn passwordColumn = this.authTable.getColumnModel().getColumn(2);
        passwordColumn.setCellEditor(new DefaultCellEditor(new JPasswordField()));
        passwordColumn.setCellRenderer(new PasswordCellRenderer());
        JScrollPane scroller = new JScrollPane(this.authTable);
        this.authTable.setPreferredScrollableViewportSize(new Dimension(520, 150));
        JTableHeader tableHeader = this.authTable.getTableHeader();
        scroller.setColumnHeaderView(tableHeader);
        tempPanel.add(scroller);
        this.addButton = new JButton(JMeterUtils.getResString((String)"add"));
        this.addButton.setMnemonic('A');
        this.addButton.setActionCommand("Add");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton(JMeterUtils.getResString((String)"delete"));
        if (this.tableModel.getRowCount() == 0) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setActionCommand("Delete");
        this.deleteButton.addActionListener(this);
        this.loadButton = new JButton(JMeterUtils.getResString((String)"load"));
        this.loadButton.setMnemonic('L');
        this.loadButton.setActionCommand("Load");
        this.loadButton.addActionListener(this);
        this.saveButton = new JButton(JMeterUtils.getResString((String)"save"));
        if (this.tableModel.getRowCount() == 0) {
            this.saveButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
        }
        this.saveButton.setMnemonic('S');
        this.saveButton.setActionCommand("Save");
        this.saveButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        tempPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        tempPanel.add(buttonPanel);
        return tempPanel;
    }

    private class PasswordCellRenderer
    extends JPasswordField
    implements TableCellRenderer {
        private Border myBorder = new EmptyBorder(1, 2, 1, 2);

        public PasswordCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.myBorder);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            this.setBackground(isSelected && !hasFocus ? table.getSelectionBackground() : table.getBackground());
            this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            this.setFont(table.getFont());
            return this;
        }
    }

    private class InnerTableModel
    extends AbstractTableModel {
        AuthManager manager;

        public InnerTableModel(AuthManager man) {
            this.manager = man;
        }

        public InnerTableModel() {
            this.manager = new AuthManager();
        }

        public void removeRow(int row) {
            this.manager.remove(row);
        }

        public void addNewRow() {
            this.manager.addAuth();
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public int getRowCount() {
            return this.manager.getAuthObjects().size();
        }

        public int getColumnCount() {
            return this.manager.getColumnCount();
        }

        public String getColumnName(int column) {
            return this.manager.getColumnName(column);
        }

        public Object getValueAt(int row, int column) {
            Authorization auth = this.manager.getAuthObjectAt(row);
            if (column == 0) {
                return auth.getURL();
            }
            if (column == 1) {
                return auth.getUser();
            }
            if (column == 2) {
                return auth.getPass();
            }
            return null;
        }

        public void setValueAt(Object value, int row, int column) {
            Authorization auth = this.manager.getAuthObjectAt(row);
            if (column == 0) {
                auth.setURL((String)value);
            } else if (column == 1) {
                auth.setUser((String)value);
            } else if (column == 2) {
                auth.setPass((String)value);
            }
        }
    }
}

