/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CookiePanel
extends AbstractConfigGui
implements ActionListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static final int columnCount = 6;
    private static final String[] columnNames;
    JTable cookieTable;
    JTextField nicknameField;
    JButton addButton;
    JButton deleteButton;
    JButton loadButton;
    JButton saveButton;
    JPanel cookieManagerPanel;
    JTextPane nicknameTextPane;
    JTextArea nicknameText;
    PowerTableModel tableModel = new PowerTableModel(columnNames, new Class[]{class$java$lang$String == null ? (class$java$lang$String = CookiePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookiePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookiePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookiePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CookiePanel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Long == null ? (class$java$lang$Long = CookiePanel.class$("java.lang.Long")) : class$java$lang$Long});
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;

    public CookiePanel() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"cookie_manager_title");
    }

    public void actionPerformed(ActionEvent e) {
        block24: {
            String action = e.getActionCommand();
            if (action.equals("Delete")) {
                if (this.tableModel.getRowCount() > 0) {
                    int rowSelected;
                    if (this.cookieTable.isEditing()) {
                        TableCellEditor cellEditor = this.cookieTable.getCellEditor(this.cookieTable.getEditingRow(), this.cookieTable.getEditingColumn());
                        cellEditor.cancelCellEditing();
                    }
                    if ((rowSelected = this.cookieTable.getSelectedRow()) != -1) {
                        this.tableModel.removeRow(rowSelected);
                        this.tableModel.fireTableDataChanged();
                        if (this.tableModel.getRowCount() == 0) {
                            this.deleteButton.setEnabled(false);
                            this.saveButton.setEnabled(false);
                        } else {
                            int rowToSelect = rowSelected;
                            if (rowSelected >= this.tableModel.getRowCount()) {
                                rowToSelect = rowSelected - 1;
                            }
                            this.cookieTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                        }
                    }
                }
            } else if (action.equals("Add")) {
                if (this.cookieTable.isEditing()) {
                    TableCellEditor cellEditor = this.cookieTable.getCellEditor(this.cookieTable.getEditingRow(), this.cookieTable.getEditingColumn());
                    cellEditor.stopCellEditing();
                }
                this.tableModel.addNewRow();
                this.tableModel.fireTableDataChanged();
                if (!this.deleteButton.isEnabled()) {
                    this.deleteButton.setEnabled(true);
                }
                if (!this.saveButton.isEnabled()) {
                    this.saveButton.setEnabled(true);
                }
                int rowToSelect = this.tableModel.getRowCount() - 1;
                this.cookieTable.setRowSelectionInterval(rowToSelect, rowToSelect);
            } else if (action.equals("Load")) {
                try {
                    File tmp = FileDialoger.promptToOpenFile().getSelectedFile();
                    if (tmp == null) break block24;
                    CookieManager manager = new CookieManager();
                    manager.addFile(tmp.getAbsolutePath());
                    Cookie cookie = manager.get(0);
                    this.addCookieToTable(cookie);
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() > 0) {
                        this.deleteButton.setEnabled(true);
                        this.saveButton.setEnabled(true);
                    }
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {}
            } else if (action.equals("Save")) {
                try {
                    File tmp = FileDialoger.promptToSaveFile(null).getSelectedFile();
                    if (tmp != null) {
                        this.createCookieManager().save(tmp.getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
            }
        }
    }

    private void addCookieToTable(Cookie cookie) {
        this.tableModel.addRow(new Object[]{cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), new Boolean(cookie.getSecure()), new Long(cookie.getExpires())});
    }

    private CookieManager createCookieManager() {
        CookieManager cookieManager = new CookieManager();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            Cookie cookie = this.createCookie(this.tableModel.getRowData(i));
            cookieManager.add(cookie);
            ++i;
        }
        return cookieManager;
    }

    private Cookie createCookie(Object[] rowData) {
        Cookie cookie = new Cookie((String)rowData[0], (String)rowData[1], (String)rowData[2], (String)rowData[3], (Boolean)rowData[4], (Long)rowData[5]);
        return cookie;
    }

    private void populateTable(CookieManager manager) {
        Iterator iter = manager.getCookies().iterator();
        while (iter.hasNext()) {
            this.addCookieToTable((Cookie)iter.next());
        }
    }

    public TestElement createTestElement() {
        CookieManager cookieManager = this.createCookieManager();
        this.configureTestElement((TestElement)cookieManager);
        return cookieManager;
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.populateTable((CookieManager)el);
    }

    public void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2));
        this.cookieManagerPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.cookieManagerPanel.setBorder(margin);
        this.cookieManagerPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"cookie_manager_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        this.cookieManagerPanel.add(panelTitleLabel);
        this.cookieManagerPanel.add((Component)this.getNamePanel());
        JPanel cookieTablePanel = this.createCookieTablePanel();
        this.cookieManagerPanel.add(cookieTablePanel);
        this.add(this.cookieManagerPanel);
    }

    public JPanel createCookieTablePanel() {
        EmptyBorder margin = new EmptyBorder(5, 10, 10, 10);
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout((LayoutManager)new VerticalLayout(0, 0));
        tempPanel.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"cookies_stored")), margin));
        this.cookieTable = new JTable((TableModel)this.tableModel);
        this.cookieTable.setCellSelectionEnabled(true);
        this.cookieTable.setRowSelectionAllowed(true);
        this.cookieTable.setColumnSelectionAllowed(false);
        this.cookieTable.setSelectionMode(0);
        JScrollPane scroller = new JScrollPane(this.cookieTable);
        this.cookieTable.setPreferredScrollableViewportSize(new Dimension(520, 150));
        JTableHeader tableHeader = this.cookieTable.getTableHeader();
        scroller.setColumnHeaderView(tableHeader);
        tempPanel.add(scroller);
        this.addButton = new JButton(JMeterUtils.getResString((String)"add"));
        this.addButton.setMnemonic('A');
        this.addButton.setActionCommand("Add");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton(JMeterUtils.getResString((String)"delete"));
        if (this.tableModel.getRowCount() == 0) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setActionCommand("Delete");
        this.deleteButton.addActionListener(this);
        this.loadButton = new JButton(JMeterUtils.getResString((String)"load"));
        this.loadButton.setMnemonic('L');
        this.loadButton.setActionCommand("Load");
        this.loadButton.addActionListener(this);
        this.saveButton = new JButton(JMeterUtils.getResString((String)"save"));
        if (this.tableModel.getRowCount() == 0) {
            this.saveButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
        }
        this.saveButton.setMnemonic('S');
        this.saveButton.setActionCommand("Save");
        this.saveButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        tempPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        tempPanel.add(buttonPanel);
        return tempPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        columnCount = 6;
        columnNames = new String[]{JMeterUtils.getResString((String)"name"), JMeterUtils.getResString((String)"value"), JMeterUtils.getResString((String)"domain"), JMeterUtils.getResString((String)"path"), JMeterUtils.getResString((String)"secure"), JMeterUtils.getResString((String)"expiration")};
    }
}

