/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class HeaderPanel
extends AbstractConfigGui
implements ActionListener,
FocusListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    InnerTableModel tableModel = new InnerTableModel();
    JTable headerTable;
    JButton addButton;
    JButton deleteButton;
    JButton loadButton;
    JButton saveButton;
    JPanel headerManagerPanel;

    public HeaderPanel() {
        this.init();
    }

    public TestElement createTestElement() {
        HeaderManager headerManager = this.tableModel.manager;
        this.configureTestElement((TestElement)headerManager);
        return (TestElement)headerManager.clone();
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.tableModel.manager = (HeaderManager)el;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"header_manager_title");
    }

    public void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2));
        this.headerManagerPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.headerManagerPanel.setBorder(margin);
        this.headerManagerPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"header_manager_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        this.headerManagerPanel.add(panelTitleLabel);
        this.headerManagerPanel.add((Component)this.getNamePanel());
        JPanel headerTablePanel = this.createHeaderTablePanel();
        this.headerManagerPanel.add(headerTablePanel);
        this.add(this.headerManagerPanel);
    }

    public void actionPerformed(ActionEvent e) {
        block24: {
            String action = e.getActionCommand();
            if (action.equals("Delete")) {
                if (this.tableModel.getRowCount() > 0) {
                    int rowSelected;
                    if (this.headerTable.isEditing()) {
                        TableCellEditor cellEditor = this.headerTable.getCellEditor(this.headerTable.getEditingRow(), this.headerTable.getEditingColumn());
                        cellEditor.cancelCellEditing();
                    }
                    if ((rowSelected = this.headerTable.getSelectedRow()) != -1) {
                        this.tableModel.removeRow(rowSelected);
                        this.tableModel.fireTableDataChanged();
                        if (this.tableModel.getRowCount() == 0) {
                            this.deleteButton.setEnabled(false);
                            this.saveButton.setEnabled(false);
                        } else {
                            int rowToSelect = rowSelected;
                            if (rowSelected >= this.tableModel.getRowCount()) {
                                rowToSelect = rowSelected - 1;
                            }
                            this.headerTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                        }
                    }
                }
            } else if (action.equals("Add")) {
                if (this.headerTable.isEditing()) {
                    TableCellEditor cellEditor = this.headerTable.getCellEditor(this.headerTable.getEditingRow(), this.headerTable.getEditingColumn());
                    cellEditor.stopCellEditing();
                }
                this.tableModel.addNewRow();
                this.tableModel.fireTableDataChanged();
                if (!this.deleteButton.isEnabled()) {
                    this.deleteButton.setEnabled(true);
                }
                if (!this.saveButton.isEnabled()) {
                    this.saveButton.setEnabled(true);
                }
                int rowToSelect = this.tableModel.getRowCount() - 1;
                this.headerTable.setRowSelectionInterval(rowToSelect, rowToSelect);
            } else if (action.equals("Load")) {
                try {
                    File tmp = FileDialoger.promptToOpenFile().getSelectedFile();
                    if (tmp == null) break block24;
                    this.tableModel.manager.addFile(tmp.getAbsolutePath());
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() > 0) {
                        this.deleteButton.setEnabled(true);
                        this.saveButton.setEnabled(true);
                    }
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {}
            } else if (action.equals("Save")) {
                try {
                    File tmp = FileDialoger.promptToSaveFile(null).getSelectedFile();
                    if (tmp != null) {
                        this.tableModel.manager.save(tmp.getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
            }
        }
    }

    public JPanel createHeaderTablePanel() {
        EmptyBorder margin = new EmptyBorder(5, 10, 10, 10);
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout((LayoutManager)new VerticalLayout(0, 0));
        tempPanel.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"headers_stored")), margin));
        this.headerTable = new JTable(this.tableModel);
        this.headerTable.addFocusListener(this);
        this.headerTable.setCellSelectionEnabled(true);
        this.headerTable.setRowSelectionAllowed(true);
        this.headerTable.setColumnSelectionAllowed(false);
        this.headerTable.setSelectionMode(0);
        JScrollPane scroller = new JScrollPane(this.headerTable);
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(520, 150));
        JTableHeader tableHeader = this.headerTable.getTableHeader();
        scroller.setColumnHeaderView(tableHeader);
        tempPanel.add(scroller);
        this.addButton = new JButton(JMeterUtils.getResString((String)"add"));
        this.addButton.setMnemonic('A');
        this.addButton.setActionCommand("Add");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton(JMeterUtils.getResString((String)"delete"));
        if (this.tableModel.getRowCount() == 0) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setActionCommand("Delete");
        this.deleteButton.addActionListener(this);
        this.loadButton = new JButton(JMeterUtils.getResString((String)"load"));
        this.loadButton.setMnemonic('L');
        this.loadButton.setActionCommand("Load");
        this.loadButton.addActionListener(this);
        this.saveButton = new JButton(JMeterUtils.getResString((String)"save"));
        if (this.tableModel.getRowCount() == 0) {
            this.saveButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
        }
        this.saveButton.setMnemonic('S');
        this.saveButton.setActionCommand("Save");
        this.saveButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        tempPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        tempPanel.add(buttonPanel);
        return tempPanel;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        try {
            this.headerTable.getCellEditor().stopCellEditing();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private class InnerTableModel
    extends AbstractTableModel {
        HeaderManager manager;

        public InnerTableModel(HeaderManager man) {
            this.manager = man;
        }

        public InnerTableModel() {
            this.manager = new HeaderManager();
        }

        public void removeRow(int row) {
            this.manager.remove(row);
        }

        public void addNewRow() {
            this.manager.add();
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public int getRowCount() {
            return this.manager.getHeaders().size();
        }

        public int getColumnCount() {
            return this.manager.getColumnCount();
        }

        public String getColumnName(int column) {
            return this.manager.getColumnName(column);
        }

        public Object getValueAt(int row, int column) {
            Header head = this.manager.getHeader(row);
            if (column == 0) {
                return head.getName();
            }
            if (column == 1) {
                return head.getValue();
            }
            return null;
        }

        public void setValueAt(Object value, int row, int column) {
            Header header = this.manager.getHeader(row);
            if (column == 0) {
                header.setName((String)value);
            } else if (column == 1) {
                header.setValue((String)value);
            }
        }
    }

    class HeaderUpdater
    implements ActionListener {
        JTextField nameField = new JTextField(20);
        JTextField valueField = new JTextField(20);
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        int index;
        JDialog updateDialog;

        public JPanel getPanel() {
            JPanel main = new JPanel();
            GridBagLayout g = new GridBagLayout();
            main.setLayout(g);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            JLabel nameLabel = new JLabel(JMeterUtils.getResString((String)"name") + ":");
            c.gridx = 1;
            c.gridy = 1;
            g.setConstraints(nameLabel, c);
            main.add(nameLabel);
            JLabel valueLabel = new JLabel(JMeterUtils.getResString((String)"value") + ":");
            c.gridx = 1;
            c.gridy = 2;
            g.setConstraints(valueLabel, c);
            main.add(valueLabel);
            c.gridx = 2;
            c.gridy = 1;
            g.setConstraints(this.nameField, c);
            main.add(this.nameField);
            c.gridx = 2;
            c.gridy = 2;
            g.setConstraints(this.valueField, c);
            main.add(this.valueField);
            JPanel buttons = new JPanel();
            this.ok.setPreferredSize(this.cancel.getPreferredSize());
            buttons.add(this.ok);
            buttons.add(this.cancel);
            c.gridwidth = 2;
            c.gridx = 1;
            c.gridy = 7;
            g.setConstraints(buttons, c);
            main.add(buttons);
            return main;
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            boolean valid = true;
            this.index = -1;
            if (command.equals("Edit")) {
                this.index = HeaderPanel.this.headerTable.getSelectedRow();
                if (this.index < 0) {
                    valid = false;
                } else {
                    Header c = HeaderPanel.this.tableModel.manager.get(this.index);
                    this.nameField = new JTextField(c.getName(), 20);
                    this.valueField = new JTextField(c.getValue(), 20);
                    this.ok = new JButton("Ok");
                    this.cancel = new JButton("Cancel");
                }
            } else if (command.equals("Add")) {
                this.nameField = new JTextField(20);
                this.valueField = new JTextField(20);
                this.ok = new JButton("Ok");
                this.cancel = new JButton("Cancel");
            }
            if (valid) {
                if (this.updateDialog != null) {
                    this.updateDialog.dispose();
                }
                this.updateDialog = new JDialog();
                this.updateDialog.setSize(350, 300);
                this.ok.addActionListener(new ActionListener(this){
                    private final /* synthetic */ HeaderUpdater this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        int i = this.this$1.index;
                        Header c = new Header();
                        if (i >= 0) {
                            c = HeaderUpdater.access$000((HeaderUpdater)this.this$1).tableModel.manager.get(this.this$1.index);
                        }
                        c.setName(this.this$1.nameField.getText());
                        c.setValue(this.this$1.valueField.getText());
                        if (i < 0) {
                            HeaderUpdater.access$000((HeaderUpdater)this.this$1).tableModel.manager.add(c);
                        }
                        HeaderUpdater.access$000((HeaderUpdater)this.this$1).tableModel.fireTableDataChanged();
                        this.this$1.updateDialog.dispose();
                    }
                });
                this.cancel.addActionListener(new ActionListener(this){
                    private final /* synthetic */ HeaderUpdater this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        this.this$1.updateDialog.dispose();
                    }
                });
                this.updateDialog.getContentPane().add(this.getPanel());
                this.updateDialog.show();
            }
        }

        static /* synthetic */ HeaderPanel access$000(HeaderUpdater x0) {
            return x0.HeaderPanel.this;
        }
    }
}

