/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ResponseBasedModifier;
import org.apache.jmeter.protocol.http.parser.HtmlParser;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AnchorModifier
extends AbstractTestElement
implements ResponseBasedModifier,
Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static Random rand = new Random();

    public boolean modifyEntry(Sampler sam, SampleResult result) {
        Document html;
        HTTPSampler sampler = null;
        if (result == null || !(sam instanceof HTTPSampler)) {
            return false;
        }
        sampler = (HTTPSampler)sam;
        ArrayList potentialLinks = new ArrayList();
        String responseText = "";
        try {
            responseText = new String(result.getResponseData(), "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            int index = responseText.indexOf("<");
            if (index == -1) {
                index = 0;
            }
            html = (Document)HtmlParser.getDOM(responseText.substring(index));
        }
        catch (SAXException e) {
            return false;
        }
        this.addAnchorUrls(html, result, sampler, potentialLinks);
        this.addFormUrls(html, result, sampler, potentialLinks);
        if (potentialLinks.size() > 0) {
            HTTPSampler url = (HTTPSampler)((Object)potentialLinks.get(rand.nextInt(potentialLinks.size())));
            sampler.setDomain(url.getDomain());
            sampler.setPath(url.getPath());
            if (url.getMethod().equals("POST")) {
                Iterator iter = sampler.getArguments().iterator();
                while (iter.hasNext()) {
                    Argument arg = (Argument)iter.next();
                    this.modifyArgument(arg, url.getArguments());
                }
            } else {
                sampler.setArguments(url.getArguments());
            }
            sampler.setProtocol(url.getProtocol());
            return true;
        }
        return false;
    }

    private void modifyArgument(Argument arg, Arguments args) {
        Argument replacementArg;
        ArrayList<Argument> possibleReplacements = new ArrayList<Argument>();
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            replacementArg = (Argument)iter.next();
            try {
                if (!HtmlParser.isArgumentMatched(replacementArg, arg)) continue;
                possibleReplacements.add(replacementArg);
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
        }
        if (possibleReplacements.size() > 0) {
            replacementArg = (Argument)possibleReplacements.get(rand.nextInt(possibleReplacements.size()));
            arg.setName(replacementArg.getName());
            arg.setValue(replacementArg.getValue());
            args.removeArgument(replacementArg);
        }
    }

    public void addConfigElement(ConfigElement config) {
    }

    private void addFormUrls(Document html, SampleResult result, HTTPSampler config, List potentialLinks) {
        NodeList rootList = html.getChildNodes();
        LinkedList urls = new LinkedList();
        int x = 0;
        while (x < rootList.getLength()) {
            urls.addAll(HtmlParser.createURLFromForm(rootList.item(x), (HTTPSampler)result.getSamplerData()));
            ++x;
        }
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            HTTPSampler newUrl = (HTTPSampler)((Object)iter.next());
            try {
                newUrl.setMethod("POST");
                if (!HtmlParser.isAnchorMatched(newUrl, config)) continue;
                potentialLinks.add(newUrl);
            }
            catch (MalformedPatternException e) {
                log.error("Bad pattern", (Throwable)e);
            }
        }
    }

    private void addAnchorUrls(Document html, SampleResult result, HTTPSampler config, List potentialLinks) {
        NodeList nodeList = html.getElementsByTagName("a");
        int i = 0;
        while (i < nodeList.getLength()) {
            Node tempNode = nodeList.item(i);
            NamedNodeMap nnm = tempNode.getAttributes();
            Node namedItem = nnm.getNamedItem("href");
            if (namedItem != null) {
                String hrefStr = namedItem.getNodeValue();
                try {
                    HTTPSampler newUrl = HtmlParser.createUrlFromAnchor(hrefStr, (HTTPSampler)result.getSamplerData());
                    newUrl.setMethod("GET");
                    if (HtmlParser.isAnchorMatched(newUrl, config)) {
                        potentialLinks.add(newUrl);
                    }
                }
                catch (MalformedURLException e) {
                }
                catch (MalformedPatternException e) {
                    log.error("Bad pattern", (Throwable)e);
                }
            }
            ++i;
        }
    }
}

