/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import org.apache.jmeter.testelement.AbstractTestElement;

public class ParamMask
extends AbstractTestElement
implements Serializable {
    private String PREFIX = "ParamModifier.prefix";
    private String FIELD_NAME = "ParamModifier.field_name";
    private String UPPER_BOUND = "ParamModifier.upper_bound";
    private String LOWER_BOUND = "ParamModifier.lower_bound";
    private String INCREMENT = "ParamModifier.increment";
    private String SUFFIX = "ParamModifier.suffix";
    private long _value = 0L;

    public ParamMask() {
        this.setFieldName("");
        this.setPrefix("");
        this.setLowerBound(0L);
        this.setUpperBound(0L);
        this.setIncrement(0L);
        this.setSuffix("");
    }

    public void setPrefix(String prefix) {
        this.setProperty(this.PREFIX, prefix);
    }

    public void setValue(long val) {
        this._value = val;
    }

    public void setFieldName(String fieldName) {
        this.setProperty(this.FIELD_NAME, fieldName);
    }

    public void setLowerBound(long val) {
        this.setProperty(this.LOWER_BOUND, new Long(val));
    }

    public void setUpperBound(long val) {
        this.setProperty(this.UPPER_BOUND, new Long(val));
    }

    public void setIncrement(long incr) {
        this.setProperty(this.INCREMENT, new Long(incr));
    }

    public void setSuffix(String suffix) {
        this.setProperty(this.SUFFIX, suffix);
    }

    public String getPrefix() {
        return (String)this.getProperty(this.PREFIX);
    }

    public long getLowerBound() {
        Object lowerBound = this.getProperty(this.LOWER_BOUND);
        return this.getLongValue(lowerBound);
    }

    public long getUpperBound() {
        Object bound = this.getProperty(this.UPPER_BOUND);
        return this.getLongValue(bound);
    }

    public long getIncrement() {
        Object inc = this.getProperty(this.INCREMENT);
        return this.getLongValue(inc);
    }

    public String getSuffix() {
        return (String)this.getProperty(this.SUFFIX);
    }

    public String getNextValue() {
        String retval = this.getPrefix() + Long.toString(this._value) + this.getSuffix();
        this._value += this.getIncrement();
        if (this._value > this.getUpperBound()) {
            this._value = this.getLowerBound();
        }
        return retval;
    }

    public void resetValue() {
        this._value = this.getLowerBound();
    }

    public String getFieldName() {
        return (String)this.getProperty(this.FIELD_NAME);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("-------------------------------\n");
        sb.append("Dumping ParamMask Object\n");
        sb.append("-------------------------------\n");
        sb.append("Name          = " + this.getFieldName() + "\n");
        sb.append("Prefix        = " + this.getPrefix() + "\n");
        sb.append("Current Value = " + this._value + "\n");
        sb.append("Lower Bound   = " + this.getLowerBound() + "\n");
        sb.append("Upper Bound   = " + this.getUpperBound() + "\n");
        sb.append("Increment     = " + this.getIncrement() + "\n");
        sb.append("Suffix        = " + this.getSuffix() + "\n");
        sb.append("-------------------------------\n");
        return sb.toString();
    }

    private long getLongValue(Object bound) {
        if (bound == null) {
            return 0L;
        }
        if (bound instanceof Long) {
            return (Long)bound;
        }
        return Long.parseLong((String)bound);
    }
}

