/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ResponseBasedModifier;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class URLRewritingModifier
extends AbstractTestElement
implements Serializable,
ResponseBasedModifier {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private Pattern case1;
    private Pattern case2;
    private Pattern case3;
    transient Perl5Compiler compiler = new Perl5Compiler();
    private static final String ARGUMENT_NAME = "argument_name";
    private static final String PATH_EXTENSION = "path_extension";

    public boolean modifyEntry(Sampler sampler, SampleResult responseText) {
        if (this.case1 == null) {
            this.initRegex(this.getArgumentName());
        }
        String text = new String(responseText.getResponseData());
        Perl5Matcher matcher = new Perl5Matcher();
        String value = "";
        if (matcher.contains(text, this.case1)) {
            MatchResult result = matcher.getMatch();
            value = result.group(1);
        } else if (matcher.contains(text, this.case2)) {
            MatchResult result = matcher.getMatch();
            value = result.group(1);
        } else if (matcher.contains(text, this.case3)) {
            MatchResult result = matcher.getMatch();
            value = result.group(1);
        }
        this.modify((HTTPSampler)sampler, value);
        return value.length() > 0;
    }

    private void modify(HTTPSampler sampler, String value) {
        if (this.isPathExtension()) {
            sampler.setPath(sampler.getPath() + ";" + this.getArgumentName() + "=" + value);
        } else {
            sampler.getArguments().removeArgument(this.getArgumentName());
            sampler.getArguments().addArgument((Argument)new HTTPArgument(this.getArgumentName(), (Object)value, true));
        }
    }

    public void setArgumentName(String argName) {
        this.setProperty(ARGUMENT_NAME, argName);
        this.case3 = null;
        this.case2 = null;
        this.case1 = null;
    }

    private void initRegex(String argName) {
        try {
            this.case1 = this.compiler.compile(argName + "=([^\"'>& \n\r]*)[& \\n\\r\"'>]?$?");
            this.case2 = this.compiler.compile("[Nn][Aa][Mm][Ee]=\"" + argName + "\"[^>]+[vV][Aa][Ll][Uu][Ee]=\"([^\"]*)\"");
            this.case3 = this.compiler.compile("[vV][Aa][Ll][Uu][Ee]=\"([^\"]*)\"[^>]+[Nn][Aa][Mm][Ee]=\"" + argName + "\"");
        }
        catch (MalformedPatternException e) {
            log.error("", (Throwable)e);
        }
    }

    public String getArgumentName() {
        return this.getPropertyAsString(ARGUMENT_NAME);
    }

    public void setPathExtension(boolean pathExt) {
        this.setProperty(PATH_EXTENSION, new Boolean(pathExt));
    }

    public boolean isPathExtension() {
        return this.getPropertyAsBoolean(PATH_EXTENSION);
    }

    static {
        ARGUMENT_NAME = ARGUMENT_NAME;
        PATH_EXTENSION = PATH_EXTENSION;
    }

    public static class Test
    extends TestCase {
        SampleResult response;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
        }

        public void testGrabSessionId() throws Exception {
            String html = "location: http://server.com/index.html?session_id=jfdkjdkf%jddkfdfjkdjfdf";
            this.response = new SampleResult();
            this.response.setResponseData(html.getBytes());
            URLRewritingModifier mod = new URLRewritingModifier();
            mod.setArgumentName("session_id");
            HTTPSampler sampler = new HTTPSampler();
            sampler.setDomain("server.com");
            sampler.setPath("index.html");
            sampler.setMethod("GET");
            sampler.setProtocol("http");
            sampler.addArgument("session_id", "adfasdfdsafasdfasd");
            mod.modifyEntry((Sampler)sampler, this.response);
            Arguments args = sampler.getArguments();
            Assert.assertEquals((Object)"jfdkjdkf%jddkfdfjkdjfdf", (Object)((Argument)args.getArguments().get(0)).getValue());
            Assert.assertEquals((Object)"http://server.com:80/index.html?session_id=jfdkjdkf%jddkfdfjkdjfdf", (Object)sampler.toString());
        }

        public void testGrabSessionId2() throws Exception {
            String html = "<a href=\"http://server.com/index.html?session_id=jfdkjdkfjddkfdfjkdjfdf\">";
            this.response = new SampleResult();
            this.response.setResponseData(html.getBytes());
            URLRewritingModifier mod = new URLRewritingModifier();
            mod.setArgumentName("session_id");
            HTTPSampler sampler = new HTTPSampler();
            sampler.setDomain("server.com");
            sampler.setPath("index.html");
            sampler.setMethod("GET");
            sampler.setProtocol("http");
            mod.modifyEntry((Sampler)sampler, this.response);
            Arguments args = sampler.getArguments();
            Assert.assertEquals((Object)"jfdkjdkfjddkfdfjkdjfdf", (Object)((Argument)args.getArguments().get(0)).getValue());
        }

        public void testGrabSessionId3() throws Exception {
            String html = "href='index.html?session_id=jfdkjdkfjddkfdfjkdjfdf'";
            this.response = new SampleResult();
            this.response.setResponseData(html.getBytes());
            URLRewritingModifier mod = new URLRewritingModifier();
            mod.setArgumentName("session_id");
            HTTPSampler sampler = new HTTPSampler();
            sampler.setDomain("server.com");
            sampler.setPath("index.html");
            sampler.setMethod("GET");
            sampler.setProtocol("http");
            mod.modifyEntry((Sampler)sampler, this.response);
            Arguments args = sampler.getArguments();
            Assert.assertEquals((Object)"jfdkjdkfjddkfdfjkdjfdf", (Object)((Argument)args.getArguments().get(0)).getValue());
        }
    }
}

