/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.Modifier;
import org.apache.jmeter.protocol.http.modifier.UserParameterXMLParser;
import org.apache.jmeter.protocol.http.modifier.UserSequence;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestListener;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class UserParameterModifier
extends ConfigTestElement
implements Modifier,
Serializable,
TestListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static final String XMLURI = "UserParameterModifier.xmluri";
    private UserSequence allAvailableUsers;

    public void testStarted() {
        List allUsers = new LinkedList();
        try {
            UserParameterXMLParser readXMLParameters = new UserParameterXMLParser();
            allUsers = readXMLParameters.getXMLParameters(this.getXmlUri());
        }
        catch (Exception e) {
            log.error("Unable to read parameters from xml file " + this.getXmlUri());
            log.error("No unique values for http requests will be substituted for each thread", (Throwable)e);
        }
        this.allAvailableUsers = new UserSequence(allUsers);
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded(String host) {
    }

    public boolean modifyEntry(Sampler entry) {
        if (!(entry instanceof HTTPSampler)) {
            return false;
        }
        HTTPSampler config = (HTTPSampler)entry;
        Map currentUser = this.allAvailableUsers.getNextUserMods();
        boolean changeValue = false;
        Iterator iter = config.getArguments().iterator();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next();
            if (!currentUser.containsKey(arg.getName())) continue;
            arg.setValue(currentUser.get(arg.getName()));
        }
        return changeValue;
    }

    public String getXmlUri() {
        return this.getPropertyAsString(XMLURI);
    }

    public void setXmlUri(String xmlURI) {
        this.setProperty(XMLURI, xmlURI);
    }

    static {
        XMLURI = XMLURI;
    }
}

