/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.config.gui.AbstractModifierGui;
import org.apache.jmeter.protocol.http.modifier.ParamMask;
import org.apache.jmeter.protocol.http.modifier.ParamModifier;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class ParamModifierGui
extends AbstractModifierGui
implements FocusListener {
    private final String NAME = "name";
    private final String PREFIX = "prefix";
    private final String LOWERBOUND = "lowerBound";
    private final String UPPERBOUND = "upperBound";
    private final String INCREMENT = "increment";
    private final String SUFFIX = "suffix";
    private JTextField _fieldName;
    private JTextField _prefix;
    private JTextField _lowerBound;
    private JTextField _upperBound;
    private JTextField _increment;
    private JTextField _suffix;

    public ParamModifierGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"HTML Parameter Mask");
    }

    public void configure(TestElement el) {
        super.configure(el);
        ParamModifier model = (ParamModifier)el;
        this.updateGui(model);
    }

    public TestElement createTestElement() {
        ParamModifier modifier = new ParamModifier();
        this.configureTestElement((TestElement)modifier);
        ParamMask mask = modifier.getMask();
        mask.setFieldName(this._fieldName.getText());
        mask.setPrefix(this._prefix.getText());
        mask.setLowerBound(Long.parseLong(this._lowerBound.getText()));
        mask.setIncrement(Long.parseLong(this._increment.getText()));
        mask.setUpperBound(Long.parseLong(this._upperBound.getText()));
        mask.setSuffix(this._suffix.getText());
        return modifier;
    }

    public void focusGained(FocusEvent evt) {
    }

    public void focusLost(FocusEvent evt) {
        String name = ((Component)evt.getSource()).getName();
        if (evt.isTemporary()) {
            return;
        }
        if (name.equals("lowerBound")) {
            this.checkTextField(evt, "0");
        } else if (name.equals("upperBound")) {
            this.checkTextField(evt, "0");
        } else if (name.equals("increment")) {
            this.checkTextField(evt, "0");
        }
    }

    protected void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"HTML Parameter Mask"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        mainPanel.add(this.getParameterMaskPanel());
        this.add(mainPanel);
        this.updateUI();
    }

    private void updateGui(ParamModifier model) {
        this._fieldName.setText(model.getMask().getFieldName());
        this._prefix.setText(model.getMask().getPrefix());
        this._lowerBound.setText(Long.toString(model.getMask().getLowerBound()));
        this._upperBound.setText(Long.toString(model.getMask().getUpperBound()));
        this._increment.setText(Long.toString(model.getMask().getIncrement()));
        this._suffix.setText(model.getMask().getSuffix());
    }

    private JPanel getParameterMaskPanel() {
        JPanel paramMaskPanel = new JPanel();
        paramMaskPanel.setLayout(new GridBagLayout());
        paramMaskPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"HTML Parameter Mask")));
        JLabel name = new JLabel(JMeterUtils.getResString((String)"Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        paramMaskPanel.add((Component)name, gridBagConstraints);
        JLabel prefix = new JLabel(JMeterUtils.getResString((String)"ID Prefix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        paramMaskPanel.add((Component)prefix, gridBagConstraints);
        JLabel start = new JLabel(JMeterUtils.getResString((String)"Lower Bound"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        paramMaskPanel.add((Component)start, gridBagConstraints);
        JLabel stop = new JLabel(JMeterUtils.getResString((String)"Upper Bound"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        paramMaskPanel.add((Component)stop, gridBagConstraints);
        JLabel increment = new JLabel(JMeterUtils.getResString((String)"Increment"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        paramMaskPanel.add((Component)increment, gridBagConstraints);
        JLabel suffix = new JLabel(JMeterUtils.getResString((String)"ID Suffix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        paramMaskPanel.add((Component)suffix, gridBagConstraints);
        this._fieldName = new JTextField("", 10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this._fieldName.setName("name");
        paramMaskPanel.add((Component)this._fieldName, gridBagConstraints);
        this._prefix = new JTextField("", 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this._prefix.setName("prefix");
        paramMaskPanel.add((Component)this._prefix, gridBagConstraints);
        this._lowerBound = new JTextField("0", 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this._lowerBound.addFocusListener(this);
        this._lowerBound.setName("lowerBound");
        paramMaskPanel.add((Component)this._lowerBound, gridBagConstraints);
        this._upperBound = new JTextField("10", 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this._upperBound.addFocusListener(this);
        this._upperBound.setName("upperBound");
        paramMaskPanel.add((Component)this._upperBound, gridBagConstraints);
        this._increment = new JTextField("1", 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this._increment.addFocusListener(this);
        this._increment.setName("increment");
        paramMaskPanel.add((Component)this._increment, gridBagConstraints);
        this._suffix = new JTextField("", 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this._suffix.setName("suffix");
        paramMaskPanel.add((Component)this._suffix, gridBagConstraints);
        return paramMaskPanel;
    }

    private long checkTextField(FocusEvent evt, String defaultValue) {
        JTextField temp = (JTextField)evt.getSource();
        boolean pass = true;
        long longVal = 0L;
        try {
            longVal = Long.parseLong(temp.getText());
        }
        catch (NumberFormatException err) {
            JOptionPane.showMessageDialog((Component)((Object)this), "This field must have a long value!", "Value Required", 0);
            temp.setText(defaultValue);
            temp.requestFocus();
        }
        return longVal;
    }
}

