/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public class HtmlParser
implements Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    protected static String utfEncodingName;
    private int compilerOptions = 32777;
    private static PatternCacheLRU patternCache;
    private static ThreadLocal localMatcher;

    /*
     * Unable to fully structure code
     */
    public static synchronized boolean isAnchorMatched(HTTPSampler newLink, HTTPSampler config) throws MalformedPatternException {
        ok = true;
        matcher = (Perl5Matcher)HtmlParser.localMatcher.get();
        iter = config.getArguments().iterator();
        query = null;
        try {
            query = URLDecoder.decode(newLink.getQueryString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (query != null || config.getArguments().getArgumentCount() <= 0) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            item = (Argument)iter.next();
            if (query.indexOf(item.getName() + "=") != -1 || (ok = ok != false && matcher.contains(query, HtmlParser.patternCache.getPattern(item.getName(), 32768)) != false)) continue;
            return false;
lbl15:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl16:
        // 1 sources

        if (config.getDomain() != null && config.getDomain().length() > 0 && !newLink.getDomain().equals(config.getDomain()) && !(ok = ok != false && matcher.matches(newLink.getDomain(), HtmlParser.patternCache.getPattern(config.getDomain(), 32768)) != false)) {
            return false;
        }
        if (!newLink.getPath().equals(config.getPath()) && !matcher.matches(newLink.getPath(), HtmlParser.patternCache.getPattern("[/]*" + config.getPath(), 32768))) {
            return false;
        }
        if (!(ok = ok != false && matcher.matches(newLink.getProtocol(), HtmlParser.patternCache.getPattern(config.getProtocol(), 32768)) != false)) {
            return false;
        }
        return ok;
    }

    public static synchronized boolean isArgumentMatched(Argument arg, Argument patternArg) throws MalformedPatternException {
        Perl5Matcher matcher = (Perl5Matcher)localMatcher.get();
        return !(!arg.getName().equals(patternArg.getName()) && !matcher.matches(arg.getName(), patternCache.getPattern(patternArg.getName(), 32768)) || !arg.getValue().equals(patternArg.getValue()) && !matcher.matches((String)arg.getValue(), patternCache.getPattern((String)patternArg.getValue(), 32768)));
    }

    public static Tidy getParser() {
        log.debug("Start : getParser1");
        Tidy tidy = new Tidy();
        tidy.setCharEncoding(3);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        if (log.isDebugEnabled()) {
            log.debug("getParser1 : tidy parser created - " + tidy);
        }
        log.debug("End : getParser1");
        return tidy;
    }

    public static Node getDOM(String text) throws SAXException {
        log.debug("Start : getDOM1");
        try {
            Document node = HtmlParser.getParser().parseDOM((InputStream)new ByteArrayInputStream(text.getBytes(HtmlParser.getUTFEncodingName())), null);
            if (log.isDebugEnabled()) {
                log.debug("node : " + node);
            }
            log.debug("End : getDOM1");
            return node;
        }
        catch (UnsupportedEncodingException e) {
            log.error("getDOM1 : Unsupported encoding exception - " + e);
            log.debug("End : getDOM1");
            throw new RuntimeException("UTF-8 encoding failed");
        }
    }

    public static String getUTFEncodingName() {
        log.debug("Start : getUTFEncodingName1");
        if (utfEncodingName == null) {
            String versionNum = System.getProperty("java.version");
            if (log.isDebugEnabled()) {
                log.debug("getUTFEncodingName1 : versionNum - " + versionNum);
            }
            utfEncodingName = versionNum.startsWith("1.1") ? "UTF8" : "UTF-8";
        }
        if (log.isDebugEnabled()) {
            log.debug("getUTFEncodingName1 : Returning utfEncodingName - " + utfEncodingName);
        }
        log.debug("End : getUTFEncodingName1");
        return utfEncodingName;
    }

    public static Document createEmptyDoc() {
        new Tidy();
        return Tidy.createEmptyDocument();
    }

    public static HTTPSampler createUrlFromAnchor(String parsedUrlString, HTTPSampler context) throws MalformedURLException {
        HTTPSampler url = new HTTPSampler();
        url.setDomain(context.getDomain());
        url.setProtocol(context.getProtocol());
        url.setPort(context.getPort());
        String contextPath = null;
        String contextFile = context.getPath();
        int indexContextQuery = contextFile.lastIndexOf(63);
        contextPath = indexContextQuery != -1 ? contextFile.substring(0, indexContextQuery) : contextFile;
        int queryStarts = parsedUrlString.indexOf("?");
        if (queryStarts == -1) {
            queryStarts = parsedUrlString.length();
        }
        if (parsedUrlString.startsWith("/")) {
            url.setPath(parsedUrlString.substring(0, queryStarts));
        } else if (parsedUrlString.startsWith("..")) {
            url.setPath(contextPath.substring(0, contextPath.substring(0, contextPath.lastIndexOf("/")).lastIndexOf("/")) + parsedUrlString.substring(2, queryStarts));
        } else if (!parsedUrlString.toLowerCase().startsWith("http")) {
            url.setPath(contextPath.substring(0, contextPath.lastIndexOf("/")) + "/" + parsedUrlString.substring(0, queryStarts));
        } else {
            URL u = new URL(parsedUrlString);
            String uPath = null;
            String uFile = u.getFile();
            int indexUQuery = uFile.lastIndexOf(63);
            uPath = indexUQuery != -1 ? uFile.substring(0, indexUQuery) : uFile;
            url.setPath(uPath);
            url.setDomain(u.getHost());
            url.setProtocol(u.getProtocol());
            url.setPort(u.getPort());
        }
        if (queryStarts < parsedUrlString.length()) {
            url.parseArguments(parsedUrlString.substring(queryStarts + 1));
        }
        return url;
    }

    public static List createURLFromForm(Node doc, HTTPSampler context) {
        String selectName = null;
        LinkedList urlConfigs = new LinkedList();
        HtmlParser.recurseForm(doc, urlConfigs, context, selectName, false);
        return urlConfigs;
    }

    private static boolean recurseForm(Node tempNode, LinkedList urlConfigs, HTTPSampler context, String selectName, boolean inForm) {
        block19: {
            NamedNodeMap nodeAtts = tempNode.getAttributes();
            String tag = tempNode.getNodeName();
            try {
                if (inForm) {
                    HTTPSampler url = (HTTPSampler)((Object)urlConfigs.getLast());
                    if (tag.equalsIgnoreCase("form")) {
                        try {
                            urlConfigs.add(HtmlParser.createFormUrlConfig(tempNode, context));
                        }
                        catch (MalformedURLException e) {
                            inForm = false;
                        }
                        break block19;
                    }
                    if (tag.equalsIgnoreCase("input")) {
                        url.addArgument(HtmlParser.getAttributeValue(nodeAtts, "name"), HtmlParser.getAttributeValue(nodeAtts, "value"));
                        break block19;
                    }
                    if (tag.equalsIgnoreCase("textarea")) {
                        try {
                            url.addArgument(HtmlParser.getAttributeValue(nodeAtts, "name"), tempNode.getFirstChild().getNodeValue());
                        }
                        catch (NullPointerException e) {
                            url.addArgument(HtmlParser.getAttributeValue(nodeAtts, "name"), "");
                        }
                        break block19;
                    }
                    if (tag.equalsIgnoreCase("select")) {
                        selectName = HtmlParser.getAttributeValue(nodeAtts, "name");
                        break block19;
                    }
                    if (!tag.equalsIgnoreCase("option")) break block19;
                    String value = HtmlParser.getAttributeValue(nodeAtts, "value");
                    if (value == null) {
                        try {
                            value = tempNode.getFirstChild().getNodeValue();
                        }
                        catch (NullPointerException e) {
                            value = "";
                        }
                    }
                    url.addArgument(selectName, value);
                    break block19;
                }
                if (!tag.equalsIgnoreCase("form")) break block19;
                try {
                    urlConfigs.add(HtmlParser.createFormUrlConfig(tempNode, context));
                    inForm = true;
                }
                catch (MalformedURLException e) {
                    inForm = false;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {}
            }
            catch (Exception ex) {
                log.warn("Some bad HTML " + HtmlParser.printNode(tempNode), (Throwable)ex);
            }
        }
        NodeList childNodes = tempNode.getChildNodes();
        int x = 0;
        while (x < childNodes.getLength()) {
            inForm = HtmlParser.recurseForm(childNodes.item(x), urlConfigs, context, selectName, inForm);
            ++x;
        }
        return inForm;
    }

    private static String getAttributeValue(NamedNodeMap att, String attName) {
        try {
            return att.getNamedItem(attName).getNodeValue();
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static String printNode(Node node) {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(node.getNodeName());
        NamedNodeMap atts = node.getAttributes();
        int x = 0;
        while (x < atts.getLength()) {
            buf.append(" ");
            buf.append(atts.item(x).getNodeName());
            buf.append("=\"");
            buf.append(atts.item(x).getNodeValue());
            buf.append("\"");
            ++x;
        }
        buf.append(">");
        return buf.toString();
    }

    private static HTTPSampler createFormUrlConfig(Node tempNode, HTTPSampler context) throws MalformedURLException {
        NamedNodeMap atts = tempNode.getAttributes();
        if (atts.getNamedItem("action") == null) {
            throw new MalformedURLException();
        }
        String action = atts.getNamedItem("action").getNodeValue();
        HTTPSampler url = HtmlParser.createUrlFromAnchor(action, context);
        return url;
    }

    static {
        patternCache = new PatternCacheLRU(1000, (PatternCompiler)new Perl5Compiler());
        localMatcher = new ThreadLocal(){

            protected Object initialValue() {
                return new Perl5Matcher();
            }
        };
    }

    public static class Test
    extends TestCase {
        private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.test");

        public Test(String name) {
            super(name);
        }

        public void testGetUTFEncodingName() {
            log.debug("Start : testGetUTFEncodingName1");
            String javaVersion = System.getProperty("java.version");
            utfEncodingName = null;
            System.setProperty("java.version", "1.1");
            Assert.assertEquals((Object)"UTF8", (Object)HtmlParser.getUTFEncodingName());
            utfEncodingName = null;
            System.setProperty("java.version", "1.2");
            Assert.assertEquals((Object)"UTF-8", (Object)HtmlParser.getUTFEncodingName());
            System.setProperty("java.version", javaVersion);
            log.debug("End : testGetUTFEncodingName1");
        }

        protected void setUp() {
        }
    }
}

