/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jmeter.protocol.http.proxy.Config;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Cache {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    String basePath = null;
    long MinFreeSpace;
    Hashtable htable;
    Config config;

    public Cache(Config configObject) {
        this.config = configObject;
        this.MinFreeSpace = 15000L;
        this.htable = new Hashtable();
        File cacheDir = new File("Cache");
        cacheDir.mkdirs();
        this.basePath = cacheDir.getAbsolutePath();
        File file = new File(this.basePath);
        String[] files = file.list();
        int i = 0;
        while (i < files.length) {
            file = new File(this.basePath + File.separatorChar + files[i]);
            file.delete();
            ++i;
        }
        this.config.setFilesCached(0L);
        this.config.setBytesCached(0L);
        this.config.setHits(0L);
        this.config.setMisses(0L);
    }

    public boolean IsCachable(String rawUrl) {
        return this.getFileName(rawUrl) != null;
    }

    public boolean IsCached(String rawUrl) {
        String filename = this.getFileName(rawUrl);
        if (filename == null) {
            return false;
        }
        return this.htable.get(filename) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInputStream getFileInputStream(String rawUrl) {
        FileInputStream in = null;
        try {
            try {
                String filename = this.getFileName(rawUrl);
                this.htable.put(filename, new Date());
                in = new FileInputStream(filename);
            }
            catch (FileNotFoundException fnf) {
                try {
                    log.warn("File Not Found:" + this.getFileName(rawUrl), (Throwable)fnf);
                }
                catch (Exception e) {
                }
                Object var6_6 = null;
                return in;
            }
            Object var6_5 = null;
            return in;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            return in;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileOutputStream getFileOutputStream(String rawUrl) {
        FileOutputStream out = null;
        try {
            try {
                String filename = this.getFileName(rawUrl);
                out = new FileOutputStream(filename);
            }
            catch (IOException e) {
                Object var6_5 = null;
                return out;
            }
            Object var6_4 = null;
            return out;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            return out;
        }
    }

    public synchronized void DecrementFreeSpace(int nbytes, String rawUrl) {
        this.config.setBytesCached(this.config.getBytesCached() + (long)nbytes);
        if (this.config.getBytesFree() <= this.MinFreeSpace) {
            this.MakeFreeSpace(rawUrl);
        }
    }

    public synchronized void AddToTable(String rawUrl) {
        String filename = this.getFileName(rawUrl);
        this.htable.put(filename, new Date());
        this.config.increaseFilesCached();
    }

    public synchronized void clean() {
        log.info("Cleaning the cache...");
        Enumeration keys = this.htable.keys();
        while (keys.hasMoreElements()) {
            String filename = (String)keys.nextElement();
            File file = new File(filename);
            long nbytes = file.length();
            boolean result = file.delete();
            if (!result) continue;
            this.htable.remove(filename);
            this.config.decreaseFilesCached();
            this.config.setBytesCached(this.config.getBytesCached() - nbytes);
        }
        this.config.setHits(0L);
        this.config.setMisses(0L);
        log.info("Cache is clean.");
    }

    private synchronized void MakeFreeSpace(String rawUrl) {
        Date minDate = new Date();
        while (this.config.getBytesFree() < this.MinFreeSpace) {
            String LRUfilename = null;
            String filename = null;
            Date date = null;
            if (this.htable.isEmpty()) {
                log.info("Could not make free space: Hash table empty...");
                return;
            }
            Enumeration keys = this.htable.keys();
            while (keys.hasMoreElements()) {
                filename = (String)keys.nextElement();
                date = (Date)this.htable.get(filename);
                if (!date.before(minDate)) continue;
                LRUfilename = filename;
            }
            File LRUfile = new File(LRUfilename);
            long nbytes = LRUfile.length();
            boolean result = LRUfile.delete();
            if (result) {
                this.htable.remove(LRUfilename);
                this.config.decreaseFilesCached();
                this.config.setBytesCached(this.config.getBytesCached() - nbytes);
                continue;
            }
            log.info("File " + LRUfilename + " could not be deleted...");
            return;
        }
    }

    private String getFileName(String rawUrl) {
        String filename = this.basePath + File.separatorChar + rawUrl.substring(7).replace('/', '@');
        if (filename.indexOf(63) != -1 || filename.indexOf("cgi-bin") != -1) {
            return null;
        }
        return filename;
    }
}

