/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

class Config {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    String jmxScriptDir;
    private boolean isFatherProxy;
    private String fatherProxyHost;
    private int fatherProxyPort;
    private String[] deniedHosts;
    private String password;
    private boolean isCaching;
    private long cacheSize;
    private boolean cleanCache;
    private String[] cacheMasks;
    private long filesCached = 0L;
    private long bytesCached = 0L;
    private long bytesFree = this.cacheSize;
    private long hits = 0L;
    private long misses = 0L;
    private final int defaultProxyPort = 8080;
    private final String defaultPassword = "admin";
    private final long defaultCacheSize = 1000000L;
    private String adminPath;
    private int adminPort;
    private String localHost;
    private String localIP;
    private boolean isAppletContext;
    private String separator = " ";
    private String proxyMachineNameAndPort;

    Config() {
        this.reset();
    }

    public void setJmxScriptDir(String filename) {
        this.jmxScriptDir = filename;
        File file = new File(System.getProperty("user.dir") + File.separator + this.jmxScriptDir);
        file.mkdirs();
    }

    public void setIsAppletContext(boolean b) {
        this.isAppletContext = b;
    }

    public void setProxyMachineNameAndPort(String s) {
        this.proxyMachineNameAndPort = s;
    }

    public void setAdminPort(int port) {
        this.adminPort = port;
    }

    public void setAdminPath(String path) {
        this.adminPath = path;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    public void setLocalIP(String ip) {
        this.localIP = ip;
    }

    public synchronized void setIsCaching(boolean caching) {
        this.isCaching = caching;
    }

    public synchronized void setCacheSize(long size) {
        this.cacheSize = size;
    }

    public synchronized void setIsFatherProxy(boolean fatherProxy) {
        this.isFatherProxy = fatherProxy;
    }

    public synchronized void setFatherProxyHost(String host) {
        this.fatherProxyHost = host;
    }

    public synchronized void setFatherProxyPort(int port) {
        this.fatherProxyPort = port;
    }

    public synchronized void setDeniedHosts(String[] hosts) {
        this.deniedHosts = hosts;
    }

    public synchronized void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public synchronized void setCleanCache(boolean clean) {
        this.cleanCache = clean;
    }

    public synchronized void setCacheMasks(String[] masks) {
        this.cacheMasks = masks;
    }

    public synchronized void setFilesCached(long number) {
        this.filesCached = number;
    }

    public synchronized void setBytesCached(long number) {
        this.bytesCached = number;
    }

    public synchronized void setHits(long number) {
        this.hits = number;
    }

    public synchronized void setMisses(long number) {
        this.misses = number;
    }

    public String getJmxScriptDir() {
        return this.jmxScriptDir;
    }

    public String getProxyMachineNameAndPort() {
        return this.proxyMachineNameAndPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public String getAdminPath() {
        return this.adminPath;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public synchronized long getCacheSize() {
        return this.cacheSize;
    }

    public boolean getIsFatherProxy() {
        return this.isFatherProxy;
    }

    public String getFatherProxyHost() {
        return this.fatherProxyHost;
    }

    public int getFatherProxyPort() {
        return this.fatherProxyPort;
    }

    public String[] getDeniedHosts() {
        return this.deniedHosts;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getCleanCache() {
        return this.cleanCache;
    }

    public String[] getCacheMasks() {
        return this.cacheMasks;
    }

    public long getFilesCached() {
        return this.filesCached;
    }

    public long getBytesCached() {
        return this.bytesCached;
    }

    public long getBytesFree() {
        return this.cacheSize - this.bytesCached;
    }

    public long getHits() {
        return this.hits;
    }

    public long getMisses() {
        return this.misses;
    }

    public double getHitRatio() {
        if (this.hits + this.misses == 0L) {
            return 0.0;
        }
        return 100L * this.hits / (this.hits + this.misses);
    }

    public void reset() {
        this.isFatherProxy = false;
        this.fatherProxyHost = "wwwproxy.ac.il";
        this.fatherProxyPort = 8080;
        this.password = "admin";
        this.isCaching = true;
        this.cacheSize = 1000000L;
        this.cleanCache = false;
        this.deniedHosts = new String[0];
        this.cacheMasks = new String[0];
    }

    public synchronized void increaseFilesCached() {
        ++this.filesCached;
    }

    public synchronized void decreaseFilesCached() {
        --this.filesCached;
    }

    public synchronized void increaseHits() {
        ++this.hits;
    }

    public synchronized void increaseMisses() {
        ++this.misses;
    }

    public synchronized String toString() {
        String s = "";
        s = s + this.isFatherProxy + this.separator;
        s = s + (this.fatherProxyHost.equals("") ? "NULL" : this.fatherProxyHost);
        s = s + this.separator + this.fatherProxyPort + this.separator;
        s = s + this.deniedHosts.length + this.separator;
        int i = 0;
        while (i < this.deniedHosts.length) {
            s = s + this.deniedHosts[i] + this.separator;
            ++i;
        }
        s = s + this.password + this.separator + this.isCaching + this.separator + this.cacheSize + this.separator + this.cleanCache + this.separator;
        s = s + this.cacheMasks.length + this.separator;
        i = 0;
        while (i < this.cacheMasks.length) {
            s = s + this.cacheMasks[i] + this.separator;
            ++i;
        }
        s = s + this.proxyMachineNameAndPort + this.separator;
        s = s + this.filesCached + this.separator + this.bytesCached + this.separator + this.bytesFree + this.separator + this.hits + this.separator + this.misses + this.separator + "\n";
        return s;
    }

    public synchronized void parse(String config) {
        log.info("Parsing administrator request...");
        StringTokenizer s = new StringTokenizer(config, this.separator);
        this.isFatherProxy = s.nextToken().equals("true");
        log.info("Use father proxy = " + this.isFatherProxy);
        this.fatherProxyHost = s.nextToken();
        if (this.fatherProxyHost.equals("NULL")) {
            this.fatherProxyHost = "";
        }
        log.info("Father proxy name = " + this.fatherProxyHost);
        this.fatherProxyPort = Integer.parseInt(s.nextToken());
        log.info("Father proxy port = " + this.fatherProxyPort);
        int size = Integer.parseInt(s.nextToken());
        this.deniedHosts = new String[size];
        int i = 0;
        while (i < size) {
            this.deniedHosts[i] = s.nextToken();
            log.info("Deny access to " + this.deniedHosts[i]);
            ++i;
        }
        this.password = s.nextToken();
        log.info("password = " + this.password);
        this.isCaching = s.nextToken().equals("true");
        log.info("Caching = " + this.isCaching);
        this.cacheSize = Long.parseLong(s.nextToken());
        log.info("Cache size = " + this.cacheSize);
        this.cleanCache = s.nextToken().equals("true");
        log.info("Do cache clean up = " + this.cleanCache);
        size = Integer.parseInt(s.nextToken());
        this.cacheMasks = new String[size];
        i = 0;
        while (i < size) {
            this.cacheMasks[i] = s.nextToken();
            log.info("Don't cache " + this.cacheMasks[i]);
            ++i;
        }
        this.proxyMachineNameAndPort = s.nextToken();
        if (this.isAppletContext) {
            this.filesCached = Long.parseLong(s.nextToken());
            this.bytesCached = Long.parseLong(s.nextToken());
            this.bytesFree = Long.parseLong(s.nextToken());
            this.hits = Long.parseLong(s.nextToken());
            this.misses = Long.parseLong(s.nextToken());
        }
        this.bytesFree = this.cacheSize - this.bytesCached;
    }

    boolean getIsCaching() {
        return this.isCaching;
    }
}

