/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.proxy.Cache;
import org.apache.jmeter.protocol.http.proxy.Config;
import org.apache.jmeter.protocol.http.proxy.Proxy;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Daemon
extends Thread {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    static ServerSocket MainSocket = null;
    static Cache cache = null;
    static Config config;
    static String adminPath;
    static final int defaultDaemonPort = 8080;
    static final int maxDaemonPort = 65536;
    private int daemonPort;
    private boolean running;
    ProxyControl target;
    private Socket ClientSocket;
    private static Class proxyClass;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$proxy$Proxy;

    public Daemon() {
    }

    public Daemon(int port, ProxyControl target) throws UnknownHostException {
        this.target = target;
        this.configureProxy(port);
    }

    public Daemon(int port, ProxyControl target, Class proxyClass) throws UnknownHostException {
        this(port, target);
        Daemon.proxyClass = proxyClass;
    }

    public void configureProxy(int daemonPort) throws UnknownHostException {
        this.daemonPort = daemonPort;
        log.info("Initializing...");
        log.info("Creating Config Object...");
        config = new Config();
        config.setIsAppletContext(false);
        config.setLocalHost(InetAddress.getLocalHost().getHostName());
        String tmp = InetAddress.getLocalHost().toString();
        config.setLocalIP(tmp.substring(tmp.indexOf(47) + 1));
        config.setProxyMachineNameAndPort(InetAddress.getLocalHost().getHostName() + ":" + daemonPort);
        config.setJmxScriptDir("proxy_script");
        File adminDir = new File("Applet");
        config.setAdminPath(adminDir.getAbsolutePath());
        log.info("Proxy: OK");
        log.info("Creating Cache Manager...");
        cache = new Cache(config);
        log.info("Proxy: OK");
    }

    public static void main(String[] args) {
        int daemonPort;
        switch (args.length) {
            case 0: {
                daemonPort = 8080;
                break;
            }
            case 1: {
                try {
                    daemonPort = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    log.error("Invalid daemon port", (Throwable)e);
                    return;
                }
                if (daemonPort <= 65536) break;
                log.error("Invalid daemon port");
                return;
            }
            default: {
                log.info("Usage: Proxy [daemon port]");
                return;
            }
        }
        Daemon demon = new Daemon();
        try {
            demon.configureProxy(daemonPort);
        }
        catch (UnknownHostException e) {
            log.fatalError("Unknown host", (Throwable)e);
            System.exit(-1);
        }
        demon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block9: {
            CookieManager cookieManager = new CookieManager();
            this.running = true;
            log.info("Creating Daemon Socket...");
            MainSocket = new ServerSocket(this.daemonPort);
            log.info(" port " + this.daemonPort + " OK");
            log.info("Proxy up and running!");
            while (this.running) {
                Socket ClientSocket = MainSocket.accept();
                Proxy thd = (Proxy)proxyClass.newInstance();
                thd.configure(ClientSocket, cache, config, this.target, cookieManager);
                thd.start();
            }
            log.info("Proxy Server stopped");
            Object var5_5 = null;
            try {
                MainSocket.close();
            }
            catch (Exception exc) {}
            break block9;
            {
                catch (Exception e) {
                    log.warn("Proxy Server stopped", (Throwable)e);
                    Object var5_6 = null;
                    try {
                        MainSocket.close();
                    }
                    catch (Exception exc) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    MainSocket.close();
                }
                catch (Exception exc) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void stopServer() {
        block8: {
            this.running = false;
            Socket endIt = null;
            endIt = new Socket(InetAddress.getLocalHost().getHostName(), this.daemonPort);
            endIt.getOutputStream().write(5);
            Object var4_2 = null;
            try {
                endIt.close();
            }
            catch (Exception e2) {}
            break block8;
            {
                catch (IOException e) {
                    Object var4_3 = null;
                    try {
                        endIt.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    endIt.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultDaemonPort = 8080;
        maxDaemonPort = 65536;
        proxyClass = class$org$apache$jmeter$protocol$http$proxy$Proxy == null ? (class$org$apache$jmeter$protocol$http$proxy$Proxy = Daemon.class$("org.apache.jmeter.protocol.http.proxy.Proxy")) : class$org$apache$jmeter$protocol$http$proxy$Proxy;
    }
}

