/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

public class HttpReplyHdr {
    static String CR = "\r\n";
    static String HTTP_PROTOCOL = "HTTP/1.0";
    static String HTTP_SERVER = "Java Proxy Server";
    String lastModified = "";
    long contentLength = 0L;
    String extraErrorString = "";

    public boolean setModifiedDate(String date) {
        this.lastModified = date;
        return true;
    }

    public boolean addErrorDescription(String str) {
        this.extraErrorString = str;
        return true;
    }

    public String formOk(String ContentType, long ContentLength) {
        this.contentLength = ContentLength;
        String out = new String();
        out = out + HTTP_PROTOCOL + " 200 Ok" + CR;
        out = out + "Server: " + HTTP_SERVER + CR;
        out = out + "MIME-version: 1.0" + CR;
        out = 0 < ContentType.length() ? out + "Content-type: " + ContentType + CR : out + "Content-Type: text/html" + CR;
        if (0L != this.contentLength) {
            out = out + "Content-Length: " + Long.toString(this.contentLength) + CR;
        }
        if (0 < this.lastModified.length()) {
            out = out + "Last-Modified: " + this.lastModified + CR;
        }
        out = out + CR;
        return out;
    }

    private String formErrorBody(String Error2, String Description) {
        String out = "<HTML><HEAD><TITLE>";
        out = out + Error2;
        out = out + "</TITLE></HEAD>";
        out = out + "<BODY><H2>" + Error2 + "</H2>\n";
        out = out + "</P></H3>";
        out = out + Description;
        out = out + "</BODY></HTML>";
        return out;
    }

    private String formError(String Error2, String Description) {
        String body = this.formErrorBody(Error2, Description);
        String header = new String();
        header = header + HTTP_PROTOCOL + " " + Error2 + CR;
        header = header + "Server: " + HTTP_SERVER + CR;
        header = header + "MIME-version: 1.0" + CR;
        header = header + "Content-type: text/html" + CR;
        if (0 < this.lastModified.length()) {
            header = header + "Last-Modified: " + this.lastModified + CR;
        }
        header = header + "Content-Length: " + String.valueOf(body.length()) + CR;
        header = header + CR;
        header = header + body;
        return header;
    }

    public String formCreated() {
        return this.formError("201 Created", "Object was created");
    }

    public String formAccepted() {
        return this.formError("202 Accepted", "Object checked in");
    }

    public String formPartial() {
        return this.formError("203 Partial", "Only partail document available");
    }

    public String formMoved() {
        return this.formError("301 Moved", "File has moved");
    }

    public String formFound() {
        return this.formError("302 Found", "Object was found");
    }

    public String formMethod() {
        return this.formError("303 Method unseported", "Method unseported");
    }

    public String formNotModified() {
        return this.formError("304 Not modified", "Use local copy");
    }

    public String formUnautorized() {
        return this.formError("401 Unathorized", "Unathorized use of this service");
    }

    public String formPaymentNeeded() {
        return this.formError("402 Payment required", "Payment is required");
    }

    public String formForbidden() {
        return this.formError("403 Forbidden", "You need permission for this service");
    }

    public String formNotFound() {
        return this.formError("404 Not_found", "Requested object was not found");
    }

    public String formInternalError() {
        return this.formError("500 Internal server error", "Server broke");
    }

    public String formNotImplemented() {
        return this.formError("501 Method not implemented", "Service not implemented, programer was lazy");
    }

    public String formOverloaded() {
        return this.formError("502 Server overloaded", "Try again latter");
    }

    public String formTimeout() {
        return this.formError("503 Gateway timeout", "The connection timed out");
    }

    public String formServerNotFound() {
        return this.formError("503 Gateway timeout", "The requested server was not found");
    }

    public String formNotAllowed() {
        return this.formError("403 Access Denied", "Access is not allowed");
    }
}

