/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.protocol.http.config.MultipartUrlConfig;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HttpRequestHdr {
    Logger log = LoggingManager.getLoggerFor((String)"jmeter.protocol.http");
    public String method = new String();
    public String url = new String();
    public String version = new String();
    public String postData = "";
    static String CR = "\r\n";
    private Map headers = new HashMap();
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$control$HeaderManager;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$gui$HeaderPanel;

    /*
     * WARNING - void declaration
     */
    public byte[] parse(InputStream in) throws IOException {
        int x;
        boolean inHeaders = true;
        int readLength = 0;
        int dataLength = 0;
        String CR = "\r\n";
        boolean first = true;
        ByteArrayOutputStream clientRequest = new ByteArrayOutputStream();
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        while ((inHeaders || readLength < dataLength) && (x = in.read()) != -1) {
            void var9_9;
            line.write((int)var9_9);
            clientRequest.write((int)var9_9);
            if (inHeaders && (byte)var9_9 == 10) {
                if (line.size() < 3) {
                    inHeaders = false;
                }
                if (first) {
                    this.parseFirstLine(line.toString());
                    first = false;
                } else {
                    dataLength = Math.max(this.parseLine(line.toString()), dataLength);
                }
                line.reset();
                continue;
            }
            if (inHeaders) continue;
            ++readLength;
        }
        this.postData = line.toString().trim();
        return clientRequest.toByteArray();
    }

    public void parseFirstLine(String firstLine) {
        this.log.debug("browser request: " + firstLine);
        StringTokenizer tz = new StringTokenizer(firstLine);
        this.method = this.getToken(tz).toUpperCase();
        this.url = this.getToken(tz);
        this.log.debug("parsed url: " + this.url);
        this.version = this.getToken(tz);
    }

    public int parseLine(String nextLine) {
        StringTokenizer tz = new StringTokenizer(nextLine);
        String token = this.getToken(tz);
        if (0 == token.length()) {
            return 0;
        }
        String name = token.trim().substring(0, token.trim().length() - 1);
        String value = this.getRemainder(tz);
        this.headers.put(name.toLowerCase(), new Header(name, value));
        if (name.equalsIgnoreCase("content-length")) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public HeaderManager getHeaderManager() {
        HeaderManager manager = new HeaderManager();
        Iterator keys = this.headers.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.equals("proxy-connection") || key.equals("content-length")) continue;
            manager.add((Header)this.headers.get(key));
        }
        manager.setName("Browser-derived headers");
        manager.setProperty("TestElement.test_class", (class$org$apache$jmeter$protocol$http$control$HeaderManager == null ? (class$org$apache$jmeter$protocol$http$control$HeaderManager = HttpRequestHdr.class$("org.apache.jmeter.protocol.http.control.HeaderManager")) : class$org$apache$jmeter$protocol$http$control$HeaderManager).getName());
        manager.setProperty("TestElement.gui_class", (class$org$apache$jmeter$protocol$http$gui$HeaderPanel == null ? (class$org$apache$jmeter$protocol$http$gui$HeaderPanel = HttpRequestHdr.class$("org.apache.jmeter.protocol.http.gui.HeaderPanel")) : class$org$apache$jmeter$protocol$http$gui$HeaderPanel).getName());
        return manager;
    }

    public HTTPSampler getSampler() throws MalformedURLException, IOException, ProtocolException {
        HttpTestSampleGui tempGui = new HttpTestSampleGui();
        tempGui.configure((TestElement)this.createSampler());
        HTTPSampler result = (HTTPSampler)tempGui.createTestElement();
        result.setFollowRedirects(false);
        result.setUseKeepAlive(true);
        return result;
    }

    public String getContentType() {
        Header contentTypeHeader = (Header)this.headers.get("content-type");
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return "";
    }

    public static MultipartUrlConfig isMultipart(String contentType) {
        if (contentType != null && contentType.startsWith(MultipartUrlConfig.MULTIPART_FORM)) {
            return new MultipartUrlConfig(contentType.substring(contentType.indexOf("oundary=") + 8));
        }
        return null;
    }

    private HTTPSampler createSampler() {
        MultipartUrlConfig urlConfig = null;
        HTTPSampler sampler = new HTTPSampler();
        sampler.setDomain(this.serverName());
        this.log.debug("Proxy: setting server: " + sampler.getDomain());
        sampler.setMethod(this.method);
        this.log.debug("Proxy: method server: " + sampler.getMethod());
        sampler.setPath(this.serverUrl());
        this.log.debug("Proxy: setting path: " + sampler.getPath());
        sampler.setName(sampler.getPath());
        sampler.setPort(this.serverPort());
        this.log.debug("Proxy: setting port: " + sampler.getPort());
        if (this.url.indexOf("//") > -1) {
            String protocol = this.url.substring(0, this.url.indexOf(":"));
            this.log.debug("Proxy: setting protocol to : " + protocol);
            sampler.setProtocol(protocol);
        } else if (sampler.getPort() == 443) {
            sampler.setProtocol("https");
            this.log.debug("Proxy: setting protocol to https");
        } else {
            this.log.debug("Proxy setting default protocol to: http");
            sampler.setProtocol("http");
        }
        urlConfig = HttpRequestHdr.isMultipart(this.getContentType());
        if (urlConfig != null) {
            urlConfig.parseArguments(this.postData);
            sampler.setArguments(urlConfig.getArguments());
            sampler.setFileField(urlConfig.getFileFieldName());
            sampler.setFilename(urlConfig.getFilename());
            sampler.setMimetype(urlConfig.getMimeType());
        } else {
            sampler.parseArguments(this.postData);
        }
        return sampler;
    }

    public String serverName() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if (0 < (i = str.indexOf("/"))) {
            str = str.substring(0, i);
        }
        if (0 < (i = str.indexOf(":"))) {
            str = str.substring(0, i);
        }
        return str;
    }

    public int serverPort() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if (0 < (i = str.indexOf("/"))) {
            str = str.substring(0, i);
        }
        if (0 < (i = str.indexOf(":"))) {
            return Integer.parseInt(str.substring(i + 1).trim());
        }
        return 80;
    }

    public String serverUrl() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if ((i = str.indexOf("/")) < 0) {
            return "";
        }
        return str.substring(i);
    }

    String getToken(StringTokenizer tk) {
        String str = "";
        if (tk.hasMoreTokens()) {
            str = tk.nextToken();
        }
        return str;
    }

    String getRemainder(StringTokenizer tk) {
        String str = "";
        if (tk.hasMoreTokens()) {
            str = tk.nextToken();
        }
        while (tk.hasMoreTokens()) {
            str = str + " " + tk.nextToken();
        }
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void setUp() {
        }

        public void testRepeatedArguments() throws Exception {
            String TEST_REQ = "GET http://localhost/matrix.html?update=yes&d=1&d=2&d=&d=&d=&d=&d=&d=1&d=2&d=1&d=&d= HTTP/1.0\n\n";
            HttpRequestHdr req = new HttpRequestHdr();
            req.parse(new ByteArrayInputStream(TEST_REQ.getBytes()));
            HTTPSampler s = req.getSampler();
            Assert.assertEquals((int)s.getArguments().getArguments().size(), (int)13);
        }
    }
}

