/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.proxy.Cache;
import org.apache.jmeter.protocol.http.proxy.Config;
import org.apache.jmeter.protocol.http.proxy.HttpReplyHdr;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Proxy
extends Thread {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    Socket ClientSocket = null;
    Socket SrvrSocket = null;
    Cache cache = null;
    String localHostName = null;
    String localHostIP = null;
    String adminPath = null;
    Config config = null;
    ProxyControl target;
    CookieManager cookieManager;

    Proxy(Socket clientSocket, Cache CacheManager, Config configObject, ProxyControl target, CookieManager cookieManager) {
        this.configure(clientSocket, CacheManager, configObject, target, cookieManager);
    }

    public Proxy() {
    }

    public void configure(Socket clientSocket, Cache CacheManager, Config configObject, ProxyControl target, CookieManager cookieManager) {
        this.cookieManager = cookieManager;
        this.target = target;
        this.config = configObject;
        this.ClientSocket = clientSocket;
        this.cache = CacheManager;
        this.localHostName = this.config.getLocalHost();
        this.localHostIP = this.config.getLocalIP();
        this.adminPath = this.config.getAdminPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block17: {
            String serverName = "";
            HttpRequestHdr request = new HttpRequestHdr();
            HttpReplyHdr reply = new HttpReplyHdr();
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            boolean TakenFromCache = false;
            boolean isCachable = false;
            byte[] clientRequest = request.parse(new BufferedInputStream(this.ClientSocket.getInputStream()));
            HTTPSampler sampler = request.getSampler();
            HeaderManager headers = request.getHeaderManager();
            sampler.setHeaderManager(headers);
            byte[] serverResponse = sampler.sample().getResponseData();
            this.writeToClient(serverResponse, new BufferedOutputStream(this.ClientSocket.getOutputStream()));
            headers.removeHeaderNamed("cookie");
            this.target.deliverSampler(sampler, new TestElement[]{headers}, serverResponse);
            Object var15_18 = null;
            try {
                this.ClientSocket.close();
            }
            catch (Exception e2) {
                log.error("", (Throwable)e2);
            }
            break block17;
            {
                catch (UnknownHostException uhe) {
                    log.warn("Server Not Found.", (Throwable)uhe);
                    try {
                        DataOutputStream out = new DataOutputStream(this.ClientSocket.getOutputStream());
                        out.writeBytes(reply.formServerNotFound());
                        out.flush();
                    }
                    catch (Exception uhe2) {
                    }
                    Object var15_19 = null;
                    try {
                        this.ClientSocket.close();
                    }
                    catch (Exception e2) {
                        log.error("", (Throwable)e2);
                    }
                    break block17;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    try {
                        if (TakenFromCache) {
                            fileInputStream.close();
                        } else if (isCachable) {
                            fileOutputStream.close();
                        }
                        DataOutputStream out = new DataOutputStream(this.ClientSocket.getOutputStream());
                        out.writeBytes(reply.formTimeout());
                        out.flush();
                    }
                    catch (Exception uhe2) {
                    }
                    Object var15_20 = null;
                    try {
                        this.ClientSocket.close();
                    }
                    catch (Exception e2) {
                        log.error("", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                try {
                    this.ClientSocket.close();
                }
                catch (Exception e2) {
                    log.error("", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public byte[] sampleServer(HTTPSampler sampler) throws IllegalAccessException, InstantiationException {
        SampleResult result = sampler.sample();
        return result.getResponseData();
    }

    private void sendAppletWebPage() {
        log.info("Sending the applet...");
        String page = "";
        try {
            File appletHtmlPage = new File(this.config.getAdminPath() + File.separator + "Admin.html");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(appletHtmlPage)));
            String s = null;
            while ((s = in.readLine()) != null) {
                page = page + s;
            }
            page = page.substring(0, page.indexOf("PORT")) + this.config.getAdminPort() + page.substring(page.indexOf("PORT") + 4);
            in.close();
            DataOutputStream out = new DataOutputStream(this.ClientSocket.getOutputStream());
            out.writeBytes(page);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.error("can't open applet html page", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendAppletClass(String className) {
        try {
            int count;
            byte[] data = new byte[2000];
            HttpReplyHdr reply = new HttpReplyHdr();
            File appletFile = new File(this.adminPath + File.separatorChar + className);
            long length = appletFile.length();
            FileInputStream in = new FileInputStream(appletFile);
            DataOutputStream out = new DataOutputStream(this.ClientSocket.getOutputStream());
            out.writeBytes(reply.formOk("application/octet-stream", length));
            while (-1 < (count = in.read(data))) {
                void var3_9;
                out.write(data, 0, (int)var3_9);
            }
            out.flush();
            in.close();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeToClient(byte[] inBytes, OutputStream out) throws IOException {
        block8: {
            out.write(inBytes);
            out.flush();
            log.info("Done writing to client");
            Object var5_3 = null;
            try {
                out.close();
            }
            catch (Exception ex) {}
            break block8;
            {
                catch (IOException e) {
                    log.error("", (Throwable)e);
                    Object var5_4 = null;
                    try {
                        out.close();
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    out.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

