/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.functions.ValueReplacer;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.gui.HeaderPanel;
import org.apache.jmeter.protocol.http.proxy.Daemon;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class ProxyControl
extends ConfigTestElement
implements Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    Daemon server;
    private final int DEFAULT_PORT = 8080;
    transient Perl5Compiler compiler;
    transient Perl5Matcher matcher = new Perl5Matcher();
    public static final String PORT = "ProxyControlGui.port";
    public static final String EXCLUDE_LIST = "ProxyControlGui.exclude_list";
    public static final String INCLUDE_LIST = "ProxyControlGui.include_list";
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$proxy$gui$ProxyControlGui;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$control$gui$RecordController;
    static /* synthetic */ Class class$org$apache$jmeter$threads$gui$ThreadGroupGui;

    public ProxyControl() {
        this.compiler = new Perl5Compiler();
        this.setPort(8080);
        this.setExcludeList(new LinkedList());
        this.setIncludeList(new LinkedList());
    }

    public void setPort(int port) {
        this.setProperty(PORT, new Integer(port));
    }

    public void setIncludeList(List list) {
        this.setProperty(INCLUDE_LIST, list);
    }

    public void setExcludeList(List list) {
        this.setProperty(EXCLUDE_LIST, list);
    }

    public String getClassLabel() {
        return JMeterUtils.getResString((String)"proxy_title");
    }

    public int getPort() {
        if (this.getProperty(PORT) instanceof String) {
            this.setPort(Integer.parseInt((String)this.getProperty(PORT)));
            return (Integer)this.getProperty(PORT);
        }
        return (Integer)this.getProperty(PORT);
    }

    public int getDefaultPort() {
        return 8080;
    }

    public Class getGuiClass() {
        return class$org$apache$jmeter$protocol$http$proxy$gui$ProxyControlGui == null ? (class$org$apache$jmeter$protocol$http$proxy$gui$ProxyControlGui = ProxyControl.class$("org.apache.jmeter.protocol.http.proxy.gui.ProxyControlGui")) : class$org$apache$jmeter$protocol$http$proxy$gui$ProxyControlGui;
    }

    public void addConfigElement(ConfigElement config) {
    }

    public void startProxy() {
        try {
            this.server = new Daemon(this.getPort(), this);
            this.server.start();
        }
        catch (UnknownHostException e) {
            log.error("", (Throwable)e);
        }
    }

    public void addExcludedPattern(String pattern) {
        this.getExcludePatterns().add(pattern);
    }

    public List getExcludePatterns() {
        return (List)this.getProperty(EXCLUDE_LIST);
    }

    public void addIncludedPattern(String pattern) {
        this.getIncludePatterns().add(pattern);
    }

    public List getIncludePatterns() {
        return (List)this.getProperty(INCLUDE_LIST);
    }

    public void clearExcludedPatterns() {
        this.getExcludePatterns().clear();
    }

    public void clearIncludedPatterns() {
        this.getIncludePatterns().clear();
    }

    public void deliverSampler(HTTPSampler sampler, TestElement[] subConfigs, byte[] serverResponse) {
        if (this.filterUrl(sampler)) {
            this.placeConfigElement(sampler, subConfigs);
        }
    }

    public void stopProxy() {
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    protected boolean filterUrl(HTTPSampler sampler) {
        boolean ok = false;
        if (sampler.getDomain() == null || sampler.getDomain().equals("")) {
            return false;
        }
        ok = this.getIncludePatterns().size() == 0 ? true : this.checkIncludes(sampler);
        if (!ok) {
            return ok;
        }
        if (this.getExcludePatterns().size() == 0) {
            return ok;
        }
        ok = this.checkExcludes(sampler);
        return ok;
    }

    private void placeConfigElement(HTTPSampler sampler, TestElement[] subConfigs) {
        ValueReplacer replacer = GuiPackage.getInstance().getReplacer();
        TestElement urlConfig = null;
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        List nodes = treeModel.getNodesOfType(class$org$apache$jmeter$protocol$http$control$gui$RecordController == null ? (class$org$apache$jmeter$protocol$http$control$gui$RecordController = ProxyControl.class$("org.apache.jmeter.protocol.http.control.gui.RecordController")) : class$org$apache$jmeter$protocol$http$control$gui$RecordController);
        if (nodes.size() == 0) {
            nodes = treeModel.getNodesOfType(class$org$apache$jmeter$threads$gui$ThreadGroupGui == null ? (class$org$apache$jmeter$threads$gui$ThreadGroupGui = ProxyControl.class$("org.apache.jmeter.threads.gui.ThreadGroupGui")) : class$org$apache$jmeter$threads$gui$ThreadGroupGui);
        }
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            JMeterTreeNode node = (JMeterTreeNode)iter.next();
            if (!node.isEnabled()) continue;
            Enumeration enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                JMeterTreeNode subNode = (JMeterTreeNode)enumeration.nextElement();
                JMeterGUIComponent sample = (JMeterGUIComponent)subNode.getUserObject();
                if (!(sample instanceof UrlConfigGui)) continue;
                urlConfig = sample.createTestElement();
                break;
            }
            if (this.areMatched(sampler, urlConfig)) {
                this.removeValuesFromSampler(sampler, urlConfig);
                replacer.reverseReplace((TestElement)sampler);
                HttpTestSampleGui test = new HttpTestSampleGui();
                test.configure((TestElement)sampler);
                try {
                    JMeterTreeNode newNode = treeModel.addComponent((Object)test, node);
                    int i = 0;
                    while (subConfigs != null && i < subConfigs.length) {
                        if (subConfigs[i] instanceof HeaderManager) {
                            HeaderPanel comp = new HeaderPanel();
                            replacer.reverseReplace(subConfigs[i]);
                            comp.configure(subConfigs[i]);
                            treeModel.addComponent((Object)comp, newNode);
                        }
                        ++i;
                    }
                }
                catch (IllegalUserActionException e) {
                    JMeterUtils.reportErrorToUser((String)e.getMessage());
                }
            }
            return;
        }
    }

    private void removeValuesFromSampler(HTTPSampler sampler, TestElement urlConfig) {
        if (urlConfig != null && sampler.getDomain().equals(urlConfig.getProperty("HTTPSampler.domain"))) {
            sampler.setDomain("");
        }
        if (urlConfig != null && sampler.getPath().equals(urlConfig.getProperty("HTTPSampler.path"))) {
            sampler.setPath("");
        }
    }

    private boolean areMatched(HTTPSampler sampler, TestElement urlConfig) {
        return urlConfig == null || (urlConfig.getProperty("HTTPSampler.domain") == null || urlConfig.getProperty("HTTPSampler.domain").equals("") || urlConfig.getProperty("HTTPSampler.domain").equals(sampler.getDomain())) && (urlConfig.getProperty("HTTPSampler.path") == null || urlConfig.getProperty("HTTPSampler.path").equals("") || urlConfig.getProperty("HTTPSampler.path").equals(sampler.getPath()));
    }

    private boolean checkIncludes(HTTPSampler sampler) {
        boolean ok = false;
        Iterator iter = this.getIncludePatterns().iterator();
        while (iter.hasNext()) {
            String item = (String)iter.next();
            try {
                Pattern pattern = this.compiler.compile(item);
                StringBuffer url = new StringBuffer(sampler.getDomain());
                url.append(":");
                url.append(sampler.getPort());
                url.append(sampler.getPath());
                if (sampler.getQueryString().length() > 0) {
                    url.append("?");
                    url.append(sampler.getQueryString());
                }
                ok = this.matcher.matches(url.toString(), pattern);
            }
            catch (MalformedPatternException e) {
                JMeterUtils.reportErrorToUser((String)("Bad Regular expression: " + item));
            }
            if (ok) break;
        }
        return ok;
    }

    private boolean checkExcludes(HTTPSampler sampler) {
        boolean ok = true;
        Iterator iter = this.getExcludePatterns().iterator();
        while (iter.hasNext()) {
            String item = (String)iter.next();
            try {
                Pattern pattern = this.compiler.compile(item);
                StringBuffer url = new StringBuffer(sampler.getDomain());
                url.append(":");
                url.append(sampler.getPort());
                url.append(sampler.getPath());
                if (sampler.getQueryString().length() > 0) {
                    url.append("?");
                    url.append(sampler.getQueryString());
                }
                ok = ok && !this.matcher.matches(url.toString(), pattern);
            }
            catch (MalformedPatternException e) {
                JMeterUtils.reportErrorToUser((String)("Bad Regular expression: " + item));
            }
            if (ok) continue;
            return ok;
        }
        return ok;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PORT = PORT;
        EXCLUDE_LIST = EXCLUDE_LIST;
        INCLUDE_LIST = INCLUDE_LIST;
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testFiltering() throws Exception {
            ProxyControl control = new ProxyControl();
            control.addIncludedPattern(".*\\.jsp");
            control.addExcludedPattern(".*apache.org.*");
            HTTPSampler sampler = new HTTPSampler();
            sampler.setDomain("jakarta.org");
            sampler.setPath("index.jsp");
            Assert.assertTrue((boolean)control.filterUrl(sampler));
            sampler.setDomain("www.apache.org");
            Assert.assertTrue((!control.filterUrl(sampler) ? 1 : 0) != 0);
            sampler.setPath("header.gif");
            sampler.setDomain("jakarta.org");
            Assert.assertTrue((!control.filterUrl(sampler) ? 1 : 0) != 0);
        }
    }
}

