/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.functions.ValueReplacer;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.NamePanel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class ProxyControlGui
extends JPanel
implements JMeterGUIComponent,
ActionListener,
KeyListener,
FocusListener {
    NamePanel namePanel = new NamePanel();
    JTextField portField;
    ProxyControl model;
    JTable excludeTable;
    PowerTableModel excludeModel;
    JTable includeTable;
    PowerTableModel includeModel;
    JButton addExclude;
    JButton deleteExclude;
    JButton addInclude;
    JButton deleteInclude;
    JButton stop;
    JButton start;
    JButton restart;
    private static final String STOP = "stop";
    private static final String START = "start";
    private static final String RESTART = "restart";
    private static final String ADD_INCLUDE = "add_include";
    private static final String ADD_EXCLUDE = "add_exclude";
    private static final String DELETE_INCLUDE = "delete_include";
    private static final String DELETE_EXCLUDE = "delete_exclude";
    private static final String INCLUDE_COL;
    private static final String EXCLUDE_COL;
    static /* synthetic */ Class class$java$lang$String;

    public ProxyControlGui() {
        this.setName(this.getStaticLabel());
        this.init();
    }

    public JPopupMenu createPopupMenu() {
        return MenuFactory.getDefaultTimerMenu();
    }

    public TestElement createTestElement() {
        ProxyControl element = new ProxyControl();
        element.setProperty("TestElement.name", this.getName());
        element.setPort(Integer.parseInt(this.portField.getText()));
        this.setIncludeListInProxyControl(element);
        this.setExcludeListInProxyControl(element);
        element.setProperty("TestElement.gui_class", this.getClass().getName());
        element.setProperty("TestElement.test_class", element.getClass().getName());
        return element;
    }

    protected void setIncludeListInProxyControl(ProxyControl element) {
        List includeList = this.getDataList(this.includeModel, INCLUDE_COL);
        element.setIncludeList(includeList);
    }

    protected void setExcludeListInProxyControl(ProxyControl element) {
        List excludeList = this.getDataList(this.excludeModel, EXCLUDE_COL);
        element.setExcludeList(excludeList);
    }

    private List getDataList(PowerTableModel model, String colName) {
        String[] dataArray = model.getData().getColumn(colName);
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        while (i < dataArray.length) {
            list.add(dataArray[i]);
            ++i;
        }
        return list;
    }

    public void setName(String name) {
        super.setName(name);
        this.namePanel.setName(name);
    }

    public String getName() {
        return this.namePanel.getName();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"proxy_title");
    }

    public Collection getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    public void configure(TestElement element) {
        ProxyControl el = (ProxyControl)element;
        this.setName(element.getProperty("TestElement.name").toString());
        this.portField.setText(element.getProperty("ProxyControlGui.port").toString());
        this.populateTable(this.includeModel, el.getIncludePatterns().iterator());
        this.populateTable(this.excludeModel, el.getExcludePatterns().iterator());
    }

    private void populateTable(PowerTableModel model, Iterator iter) {
        while (iter.hasNext()) {
            model.addRow(new Object[]{iter.next()});
        }
    }

    public void focusLost(FocusEvent e) {
        try {
            ((JTable)e.getSource()).getCellEditor().stopCellEditing();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        if (command.equals(STOP)) {
            this.model.stopProxy();
            this.stop.setEnabled(false);
            this.start.setEnabled(true);
            this.model = null;
        } else if (command.equals(START)) {
            this.model = (ProxyControl)this.createTestElement();
            this.startProxy();
        } else if (command.equals(RESTART)) {
            this.model.stopProxy();
            this.model = (ProxyControl)this.createTestElement();
            this.startProxy();
        } else if (command.equals(ADD_EXCLUDE)) {
            this.excludeModel.addNewRow();
            this.excludeModel.fireTableDataChanged();
            if (this.model != null) {
                this.enableRestart();
            }
        } else if (command.equals(ADD_INCLUDE)) {
            this.includeModel.addNewRow();
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_EXCLUDE)) {
            this.excludeModel.removeRow(this.excludeTable.getSelectedRow());
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_INCLUDE)) {
            this.includeModel.removeRow(this.includeTable.getSelectedRow());
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        }
    }

    private void startProxy() {
        ValueReplacer replacer = GuiPackage.getInstance().getReplacer();
        try {
            replacer.replaceValues((TestElement)this.model);
            this.model.startProxy();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
            this.restart.setEnabled(false);
        }
        catch (InvalidVariableException e) {
            JOptionPane.showMessageDialog(this, JMeterUtils.getResString((String)"invalid_variables"), "Error", 0);
        }
    }

    private void enableRestart() {
        if (this.model != null) {
            this.restart.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        block3: {
            String fieldName = e.getComponent().getName();
            if (fieldName.equals("ProxyControlGui.port")) {
                try {
                    Integer.parseInt(this.portField.getText());
                }
                catch (NumberFormatException nfe) {
                    if (this.portField.getText().length() <= 0) break block3;
                    JOptionPane.showMessageDialog(this, "You must enter a valid number", "Invalid data", 2);
                    this.portField.setText("");
                }
            }
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel mainPanel = new JPanel();
        this.add((Component)mainPanel, gbc.clone());
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new GridBagLayout());
        gbc.weighty = 0.0;
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"proxy_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add((Component)panelTitleLabel, gbc.clone());
        ++gbc.gridy;
        mainPanel.add((Component)this.namePanel, gbc.clone());
        ++gbc.gridy;
        mainPanel.add((Component)this.createPortPanel(), gbc.clone());
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 0.5;
        mainPanel.add((Component)this.createIncludePanel(), gbc.clone());
        ++gbc.gridy;
        mainPanel.add((Component)this.createExcludePanel(), gbc.clone());
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        mainPanel.add((Component)this.createControls(), gbc.clone());
    }

    private JPanel createControls() {
        JPanel panel = new JPanel();
        this.start = new JButton(JMeterUtils.getResString((String)START));
        this.start.addActionListener(this);
        this.start.setActionCommand(START);
        this.stop = new JButton(JMeterUtils.getResString((String)STOP));
        this.stop.addActionListener(this);
        this.stop.setActionCommand(STOP);
        this.restart = new JButton(JMeterUtils.getResString((String)RESTART));
        this.restart.addActionListener(this);
        this.restart.setActionCommand(RESTART);
        panel.add(this.start);
        panel.add(this.stop);
        panel.add(this.restart);
        this.start.setEnabled(true);
        this.stop.setEnabled(false);
        this.restart.setEnabled(false);
        return panel;
    }

    private JPanel createPortPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(JMeterUtils.getResString((String)"port")));
        this.portField = new JTextField(8);
        this.portField.setName("ProxyControlGui.port");
        this.portField.addKeyListener(this);
        this.portField.setText("8080");
        panel.add(this.portField);
        panel.revalidate();
        return panel;
    }

    private JPanel createIncludePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"patterns_to_include")));
        this.includeTable = new JTable();
        this.includeModel = new PowerTableModel(new String[]{INCLUDE_COL}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ProxyControlGui.class$("java.lang.String")) : class$java$lang$String});
        JScrollPane scroller = new JScrollPane(this.includeTable);
        scroller.setBackground(panel.getBackground());
        this.includeTable.setModel((TableModel)this.includeModel);
        this.addInclude = new JButton(JMeterUtils.getResString((String)"add"));
        this.deleteInclude = new JButton(JMeterUtils.getResString((String)"delete"));
        this.addInclude.setActionCommand(ADD_INCLUDE);
        this.deleteInclude.setActionCommand(DELETE_INCLUDE);
        this.addInclude.addActionListener(this);
        this.deleteInclude.addActionListener(this);
        panel.add((Component)scroller, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addInclude);
        buttonPanel.add(this.deleteInclude);
        panel.add((Component)buttonPanel, "South");
        this.includeTable.addFocusListener(this);
        return panel;
    }

    private JPanel createExcludePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"patterns_to_exclude")));
        this.excludeTable = new JTable();
        this.excludeModel = new PowerTableModel(new String[]{EXCLUDE_COL}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ProxyControlGui.class$("java.lang.String")) : class$java$lang$String});
        JScrollPane scroller = new JScrollPane(this.excludeTable);
        scroller.setBackground(panel.getBackground());
        this.excludeTable.setModel((TableModel)this.excludeModel);
        this.addExclude = new JButton(JMeterUtils.getResString((String)"add"));
        this.deleteExclude = new JButton(JMeterUtils.getResString((String)"delete"));
        this.addExclude.setActionCommand(ADD_EXCLUDE);
        this.deleteExclude.setActionCommand(DELETE_EXCLUDE);
        this.addExclude.addActionListener(this);
        this.deleteExclude.addActionListener(this);
        panel.add((Component)scroller, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addExclude);
        buttonPanel.add(this.deleteExclude);
        panel.add((Component)buttonPanel, "South");
        this.excludeTable.addFocusListener(this);
        return panel;
    }

    public void setNode(JMeterTreeNode node) {
        this.namePanel.setNode(node);
    }

    protected JTextField getPortField() {
        return this.portField;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        STOP = STOP;
        START = START;
        RESTART = RESTART;
        ADD_INCLUDE = ADD_INCLUDE;
        ADD_EXCLUDE = ADD_EXCLUDE;
        DELETE_INCLUDE = DELETE_INCLUDE;
        DELETE_EXCLUDE = DELETE_EXCLUDE;
        INCLUDE_COL = JMeterUtils.getResString((String)"patterns_to_include");
        EXCLUDE_COL = JMeterUtils.getResString((String)"patterns_to_exclude");
    }
}

