/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.PostWriter;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class HTTPSampler
extends AbstractSampler {
    public static final String HEADERS = "headers";
    public static final String HEADER = "header";
    public static final String ARGUMENTS = "HTTPsampler.Arguments";
    public static final String AUTH_MANAGER = "HTTPSampler.auth_manager";
    public static final String COOKIE_MANAGER = "HTTPSampler.cookie_manager";
    public static final String HEADER_MANAGER = "HTTPSampler.header_manager";
    public static final String MIMETYPE = "HTTPSampler.mimetype";
    public static final String DOMAIN = "HTTPSampler.domain";
    public static final String PORT = "HTTPSampler.port";
    public static final String METHOD = "HTTPSampler.method";
    public static final String PATH = "HTTPSampler.path";
    public static final String FOLLOW_REDIRECTS = "HTTPSampler.follow_redirects";
    public static final String PROTOCOL = "HTTPSampler.protocol";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String URL = "HTTPSampler.URL";
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String USE_KEEPALIVE = "HTTPSampler.use_keepalive";
    public static final String FILE_NAME = "HTTPSampler.FILE_NAME";
    public static final String FILE_FIELD = "HTTPSampler.FILE_FIELD";
    public static final String FILE_DATA = "HTTPSampler.FILE_DATA";
    public static final String FILE_MIMETYPE = "HTTPSampler.FILE_MIMETYPE";
    public static final String CONTENT_TYPE = "HTTPSampler.CONTENT_TYPE";
    public static final String NORMAL_FORM = "normal_form";
    public static final String MULTIPART_FORM = "multipart_form";
    private static final int MAX_REDIRECTS = 10;
    protected static String encoding;
    private static final PostWriter postWriter;
    protected transient HttpURLConnection conn;
    private int connectionTries = 0;
    protected static final String NON_HTTP_RESPONSE_CODE = "Non HTTP response code";
    protected static final String NON_HTTP_RESPONSE_MESSAGE = "Non HTTP response message";
    private static transient Logger log;
    private ArrayList m_sampledURLs = new ArrayList();

    public void setFileField(String value) {
        this.setProperty(FILE_FIELD, value);
    }

    public String getFileField() {
        return this.getPropertyAsString(FILE_FIELD);
    }

    public void setFilename(String value) {
        this.setProperty(FILE_NAME, value);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILE_NAME);
    }

    public void setProtocol(String value) {
        this.setProperty(PROTOCOL, value);
    }

    public String getProtocol() {
        String protocol = this.getPropertyAsString(PROTOCOL);
        if (protocol == null || protocol.equals("")) {
            return DEFAULT_PROTOCOL;
        }
        return protocol;
    }

    public void setPath(String path) {
        if (GET.equals(this.getMethod())) {
            int index = path.indexOf("?");
            if (index > -1) {
                this.setProperty(PATH, path.substring(0, index));
                this.parseArguments(path.substring(index + 1));
            } else {
                this.setProperty(PATH, path);
            }
        } else {
            this.setProperty(PATH, path);
        }
    }

    public String getPath() {
        return this.getPropertyAsString(PATH);
    }

    public void setFollowRedirects(boolean value) {
        this.setProperty(FOLLOW_REDIRECTS, new Boolean(value));
    }

    public boolean getFollowRedirects() {
        return this.getPropertyAsBoolean(FOLLOW_REDIRECTS);
    }

    public void setMethod(String value) {
        this.setProperty(METHOD, value);
    }

    public String getMethod() {
        return this.getPropertyAsString(METHOD);
    }

    public void setUseKeepAlive(boolean value) {
        this.setProperty(USE_KEEPALIVE, new Boolean(value));
    }

    public boolean getUseKeepAlive() {
        return this.getPropertyAsBoolean(USE_KEEPALIVE);
    }

    public void addEncodedArgument(String name, String value, String metaData) {
        Arguments args = this.getArguments();
        HTTPArgument arg = new HTTPArgument(name, value, metaData, true);
        if (arg.getName().equals(arg.getEncodedName()) && arg.getValue().equals(arg.getEncodedValue())) {
            arg.setAlwaysEncode(false);
        }
        args.addArgument((Argument)arg);
    }

    public void addArgument(String name, String value) {
        Arguments args = this.getArguments();
        args.addArgument((Argument)new HTTPArgument(name, value));
    }

    public void addArgument(String name, String value, String metadata) {
        Arguments args = this.getArguments();
        args.addArgument((Argument)new HTTPArgument(name, (Object)value, metadata));
    }

    public void setPort(int value) {
        this.setProperty(PORT, new Integer(value));
    }

    public int getPort() {
        int port = this.getPropertyAsInt(PORT);
        if (port == 0) {
            if ("https".equalsIgnoreCase(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    public void setDomain(String value) {
        this.setProperty(DOMAIN, value);
    }

    public String getDomain() {
        return (String)this.getProperty(DOMAIN);
    }

    public void setArguments(Arguments value) {
        this.setProperty(ARGUMENTS, value);
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS);
    }

    public void setAuthManager(AuthManager value) {
        this.setProperty(AUTH_MANAGER, value);
    }

    public AuthManager getAuthManager() {
        return (AuthManager)this.getProperty(AUTH_MANAGER);
    }

    public void setHeaderManager(HeaderManager value) {
        this.setProperty(HEADER_MANAGER, value);
    }

    public HeaderManager getHeaderManager() {
        return (HeaderManager)this.getProperty(HEADER_MANAGER);
    }

    public void setCookieManager(CookieManager value) {
        this.setProperty(COOKIE_MANAGER, value);
    }

    public CookieManager getCookieManager() {
        return (CookieManager)this.getProperty(COOKIE_MANAGER);
    }

    public void setMimetype(String value) {
        this.setProperty(MIMETYPE, value);
    }

    public String getMimetype() {
        return (String)this.getProperty(MIMETYPE);
    }

    protected void addCustomTestElement(TestElement element) {
        if (element instanceof Arguments) {
            if (this.getProperty(ARGUMENTS) != null) {
                ((Arguments)this.getProperty(ARGUMENTS)).addTestElement(element);
            } else {
                this.setProperty(ARGUMENTS, element);
            }
        } else if (element instanceof AuthManager) {
            if (this.getProperty(AUTH_MANAGER) != null) {
                ((TestElement)this.getProperty(AUTH_MANAGER)).addTestElement(element);
            } else {
                this.setProperty(AUTH_MANAGER, element);
            }
        } else if (element instanceof CookieManager) {
            if (this.getProperty(COOKIE_MANAGER) != null) {
                ((TestElement)this.getProperty(COOKIE_MANAGER)).addTestElement(element);
            } else {
                this.setProperty(COOKIE_MANAGER, element);
            }
        } else if (element instanceof HeaderManager) {
            if (this.getProperty(HEADER_MANAGER) != null) {
                ((TestElement)this.getProperty(HEADER_MANAGER)).addTestElement(element);
            } else {
                this.setProperty(HEADER_MANAGER, element);
            }
        } else if (element instanceof HTTPSampler || element instanceof ConfigTestElement) {
            this.mergeIn(element);
        }
    }

    public HTTPSampler() {
        this.setArguments(new Arguments());
    }

    public HTTPSampler(URL u) {
        this.setMethod(GET);
        this.setDomain(u.getHost());
        this.setPath(u.getPath());
        this.setPort(u.getPort());
        this.setProtocol(u.getProtocol());
        this.parseArguments(u.getQuery());
        this.setFollowRedirects(true);
        this.setUseKeepAlive(true);
        this.setArguments(new Arguments());
    }

    public SampleResult sample(Entry e) {
        return this.sample(0);
    }

    public SampleResult sample() {
        return this.sample(0);
    }

    public URL getUrl() throws MalformedURLException {
        String pathAndQuery = null;
        pathAndQuery = this.getMethod().equals(GET) && this.getQueryString().length() > 0 ? (this.getPath().indexOf("?") > -1 ? this.getPath() + "&" + this.getQueryString() : this.getPath() + "?" + this.getQueryString()) : this.getPath();
        if (!pathAndQuery.startsWith("/")) {
            pathAndQuery = "/" + pathAndQuery;
        }
        if (this.getPort() == 0) {
            return new URL(this.getProtocol(), this.getDomain(), pathAndQuery);
        }
        return new URL(this.getProtocol(), (String)this.getProperty(DOMAIN), this.getPort(), pathAndQuery);
    }

    public String getQueryString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.getArguments().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            HTTPArgument item = (HTTPArgument)iter.next();
            if (!first) {
                buf.append("&");
            } else {
                first = false;
            }
            buf.append(item.getEncodedName());
            if (item.getMetaData() == null) {
                buf.append("=");
            } else {
                buf.append(item.getMetaData());
            }
            buf.append(item.getEncodedValue());
        }
        return buf.toString();
    }

    public void setPostHeaders(URLConnection conn) throws IOException {
        postWriter.setHeaders(conn, this);
    }

    public void sendPostData(URLConnection connection) throws IOException {
        postWriter.sendPostData(connection, this);
    }

    protected HttpURLConnection setupConnection(URL u, String method) throws IOException {
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        if ("https".equals(u.getProtocol())) {
            try {
                SSLManager.getInstance().setContext(conn);
            }
            catch (Exception e) {
                log.warn("You may have forgotten to set the ssl.provider property in jmeter.properties", (Throwable)e);
            }
        }
        if (this.getUseKeepAlive()) {
            conn.setRequestProperty("Connection", "keep-alive");
        } else {
            conn.setRequestProperty("Connection", "close");
        }
        conn.setRequestMethod(method);
        this.setConnectionHeaders(conn, u, this.getHeaderManager());
        this.setConnectionCookie(conn, u, this.getCookieManager());
        this.setConnectionAuthorization(conn, u, this.getAuthManager());
        return conn;
    }

    public void parseArguments(String queryString) {
        String[] args = JOrphanUtils.split((String)queryString, (String)"&");
        int i = 0;
        while (i < args.length) {
            int endOfNameIndex = 0;
            String metaData = "";
            if (args[i].indexOf("=") != -1) {
                endOfNameIndex = args[i].indexOf("=");
                metaData = "=";
            } else {
                metaData = "";
                endOfNameIndex = args[i].length() > 0 ? args[i].length() : 0;
            }
            String name = "";
            if (args[i].length() > 0) {
                name = args[i].substring(0, endOfNameIndex);
            }
            String value = "";
            if (endOfNameIndex + 1 < args[i].length()) {
                value = args[i].substring(endOfNameIndex + 1, args[i].length());
            }
            if (name.length() > 0) {
                try {
                    this.addEncodedArgument(name, value, metaData);
                }
                catch (Exception e) {
                    log.error("UrlConfig:parseArguments(): Unable to parse argument=[" + value + "]");
                    log.error("UrlConfig:parseArguments(): queryString=[" + queryString + "]", (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected byte[] readResponse(HttpURLConnection conn) throws IOException {
        BufferedInputStream in;
        byte[] buffer = new byte[4096];
        try {
            in = new BufferedInputStream(conn.getInputStream());
        }
        catch (Exception e) {
            in = new BufferedInputStream(conn.getErrorStream());
        }
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        int x = 0;
        while ((x = in.read(buffer)) > -1) {
            w.write(buffer, 0, x);
        }
        in.close();
        w.flush();
        w.close();
        return w.toByteArray();
    }

    protected byte[] getResponseHeaders(HttpURLConnection conn, SampleResult res) throws IOException {
        StringBuffer headerBuf = new StringBuffer();
        headerBuf.append(conn.getHeaderField(0).substring(0, 8));
        headerBuf.append(" ");
        headerBuf.append(conn.getResponseCode());
        headerBuf.append(" ");
        headerBuf.append(conn.getResponseMessage());
        headerBuf.append("\n");
        int i = 1;
        while (conn.getHeaderFieldKey(i) != null) {
            if (!conn.getHeaderFieldKey(i).equalsIgnoreCase("transfer-encoding")) {
                headerBuf.append(conn.getHeaderFieldKey(i));
                headerBuf.append(": ");
                headerBuf.append(conn.getHeaderField(i));
                headerBuf.append("\n");
            }
            ++i;
        }
        headerBuf.append("\n");
        return headerBuf.toString().getBytes("8859_1");
    }

    private void setConnectionCookie(HttpURLConnection conn, URL u, CookieManager cookieManager) {
        String cookieHeader;
        if (cookieManager != null && (cookieHeader = cookieManager.getCookieHeaderForURL(u)) != null) {
            conn.setRequestProperty("Cookie", cookieHeader);
        }
    }

    private void setConnectionHeaders(HttpURLConnection conn, URL u, HeaderManager headerManager) {
        List headers;
        if (headerManager != null && (headers = headerManager.getHeaders()) != null) {
            Iterator i = headers.iterator();
            while (i.hasNext()) {
                Header header = (Header)i.next();
                conn.setRequestProperty(header.getName(), header.getValue());
            }
        }
    }

    private void setConnectionAuthorization(HttpURLConnection conn, URL u, AuthManager authManager) {
        String authHeader;
        if (authManager != null && (authHeader = authManager.getAuthHeaderForURL(u)) != null) {
            conn.setRequestProperty("Authorization", authHeader);
        }
    }

    private int getErrorLevel(HttpURLConnection conn, SampleResult res, long time) throws IOException {
        int errorLevel = 200;
        String message = null;
        errorLevel = conn.getResponseCode();
        message = conn.getResponseMessage();
        res.setResponseCode(String.valueOf(errorLevel));
        res.setResponseMessage(message);
        return errorLevel;
    }

    public void removeArguments() {
        this.setProperty(ARGUMENTS, new Arguments());
    }

    private void redirectUrl(HttpURLConnection conn, URL u) throws MalformedURLException {
        String loc = conn.getHeaderField("Location");
        if (loc != null && loc.indexOf(DEFAULT_PROTOCOL) == -1) {
            String tempURL = u.toString();
            if (loc.startsWith("/")) {
                int ind = tempURL.indexOf("//") + 2;
                loc = tempURL.substring(0, tempURL.indexOf("/", ind) + 1) + loc.substring(1);
            } else {
                loc = u.toString().substring(0, u.toString().lastIndexOf(47) + 1) + loc;
            }
        }
        URL newUrl = new URL(loc);
        this.setMethod(GET);
        this.setProtocol(newUrl.getProtocol());
        this.setDomain(newUrl.getHost());
        this.setPort(newUrl.getPort());
        this.setPath(newUrl.getFile());
        this.removeArguments();
        this.parseArguments(newUrl.getQuery());
    }

    protected long connect() throws IOException {
        long time = System.currentTimeMillis();
        try {
            this.conn.connect();
        }
        catch (BindException e) {
            log.debug("Bind exception, try again");
            if (this.connectionTries++ == 10) {
                log.error("Can't connect", (Throwable)e);
                throw e;
            }
            this.conn.disconnect();
            this.conn = null;
            System.gc();
            Runtime.getRuntime().runFinalization();
            this.setUseKeepAlive(false);
            this.conn = this.setupConnection(this.getUrl(), this.getMethod());
            if (this.getMethod().equals(POST)) {
                this.setPostHeaders(this.conn);
            }
            time = this.connect();
        }
        catch (IOException e) {
            log.debug("Connection failed, giving up");
            this.conn.disconnect();
            this.conn = null;
            System.gc();
            Runtime.getRuntime().runFinalization();
            throw e;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private SampleResult sample(int redirects) {
        log.debug("Start : sample2");
        long time = System.currentTimeMillis();
        SampleResult res = new SampleResult();
        URL u = null;
        u = this.getUrl();
        res.setSampleLabel(this.getName());
        res.setSamplerData((TestElement)this);
        if (log.isDebugEnabled()) {
            log.debug("sample2 : sampling url - " + u);
        }
        this.conn = this.setupConnection(u, this.getMethod());
        if (this.getProperty(METHOD).equals(POST)) {
            this.setPostHeaders(this.conn);
            time = this.connect();
            this.sendPostData(this.conn);
        } else {
            time = this.connect();
        }
        this.saveConnectionCookies(this.conn, u, this.getCookieManager());
        int errorLevel = 0;
        try {
            errorLevel = this.getErrorLevel(this.conn, res, time);
        }
        catch (IOException e) {
            time = this.bundleResponseInResult(time, res, this.conn);
            res.setSuccessful(false);
            res.setTime(time);
            SampleResult sampleResult = res;
            Object var10_11 = null;
            try {
                String connection = this.conn.getHeaderField("Connection");
                if (connection == null || connection.equalsIgnoreCase("close")) {
                    this.conn.disconnect();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            return sampleResult;
        }
        if (errorLevel / 100 == 2 || errorLevel == 304) {
            time = this.bundleResponseInResult(time, res, this.conn);
        } else if (errorLevel / 100 == 3) {
            if (redirects >= 10) {
                throw new IOException("Maximum number of redirects exceeded");
            }
            if (!this.getFollowRedirects()) {
                time = this.bundleResponseInResult(time, res, this.conn);
            } else {
                time = System.currentTimeMillis() - time;
                HTTPSampler redirect = (HTTPSampler)((Object)this.clone());
                redirect.redirectUrl(this.conn, u);
                SampleResult redirectResult = redirect.sample(redirects + 1);
                res.addSubResult(redirectResult);
                res.setResponseData(redirectResult.getResponseData());
                time += redirectResult.getTime();
            }
        } else {
            time = this.bundleResponseInResult(time, res, this.conn);
            res.setSuccessful(false);
        }
        res.setTime(time);
        log.debug("End : sample2");
        SampleResult sampleResult = res;
        Object var10_12 = null;
        try {
            String connection = this.conn.getHeaderField("Connection");
            if (connection == null || connection.equalsIgnoreCase("close")) {
                this.conn.disconnect();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return sampleResult;
        catch (IOException ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
            res.setDataType("text");
            res.setResponseData(ex.toString().getBytes());
            res.setResponseCode(NON_HTTP_RESPONSE_CODE);
            res.setResponseMessage(NON_HTTP_RESPONSE_MESSAGE);
            res.setTime(System.currentTimeMillis() - time);
            res.setSuccessful(false);
            Object var10_13 = null;
            {
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    try {
                        String connection = this.conn.getHeaderField("Connection");
                        if (connection == null || connection.equalsIgnoreCase("close")) {
                            this.conn.disconnect();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                String connection = this.conn.getHeaderField("Connection");
                if (connection == null || connection.equalsIgnoreCase("close")) {
                    this.conn.disconnect();
                }
            }
            catch (Exception e2) {}
        }
        log.debug("End : sample2");
        return res;
    }

    private long bundleResponseInResult(long time, SampleResult res, HttpURLConnection conn) throws IOException, FileNotFoundException {
        res.setDataType("text");
        byte[] ret = this.readResponse(conn);
        byte[] head = this.getResponseHeaders(conn, res);
        time = System.currentTimeMillis() - time;
        byte[] complete = new byte[ret.length + head.length];
        System.arraycopy(head, 0, complete, 0, head.length);
        System.arraycopy(ret, 0, complete, head.length, ret.length);
        res.setResponseData(complete);
        res.setSuccessful(true);
        return time;
    }

    private void saveConnectionCookies(HttpURLConnection conn, URL u, CookieManager cookieManager) {
        if (cookieManager != null) {
            int i = 1;
            while (conn.getHeaderFieldKey(i) != null) {
                if (conn.getHeaderFieldKey(i).equalsIgnoreCase("set-cookie")) {
                    cookieManager.addCookieFromHeader(conn.getHeaderField(i), u);
                }
                ++i;
            }
        }
    }

    public String toString() {
        try {
            return this.getUrl().toString() + (POST.equals(this.getMethod()) ? "\nQuery Data: " + this.getQueryString() : "");
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    static {
        HEADERS = HEADERS;
        HEADER = HEADER;
        ARGUMENTS = ARGUMENTS;
        AUTH_MANAGER = AUTH_MANAGER;
        COOKIE_MANAGER = COOKIE_MANAGER;
        HEADER_MANAGER = HEADER_MANAGER;
        MIMETYPE = MIMETYPE;
        DOMAIN = DOMAIN;
        PORT = PORT;
        METHOD = METHOD;
        PATH = PATH;
        FOLLOW_REDIRECTS = FOLLOW_REDIRECTS;
        PROTOCOL = PROTOCOL;
        DEFAULT_PROTOCOL = DEFAULT_PROTOCOL;
        URL = URL;
        POST = POST;
        GET = GET;
        USE_KEEPALIVE = USE_KEEPALIVE;
        FILE_NAME = FILE_NAME;
        FILE_FIELD = FILE_FIELD;
        FILE_DATA = FILE_DATA;
        FILE_MIMETYPE = FILE_MIMETYPE;
        CONTENT_TYPE = CONTENT_TYPE;
        NORMAL_FORM = NORMAL_FORM;
        MULTIPART_FORM = MULTIPART_FORM;
        MAX_REDIRECTS = 10;
        encoding = "iso-8859-1";
        postWriter = new PostWriter();
        NON_HTTP_RESPONSE_CODE = NON_HTTP_RESPONSE_CODE;
        NON_HTTP_RESPONSE_MESSAGE = NON_HTTP_RESPONSE_MESSAGE;
        log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testMakingUrl() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "value1");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?param1=value1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl2() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "value1");
            config.setPath("/index.html?p1=p2");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?param1=value1&p1=p2", (Object)config.getUrl().toString());
        }

        public void testMakingUrl3() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.POST);
            config.addArgument("param1", "value1");
            config.setPath("/index.html?p1=p2");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?p1=p2", (Object)config.getUrl().toString());
        }

        public void testMakingUrl4() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "value1", "=");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?param1=value1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl5() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "", "=");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?param1=", (Object)config.getUrl().toString());
        }

        public void testMakingUrl6() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "", "");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?param1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl7() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.parseArguments("param1=value1");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?param1=value1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl8() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.parseArguments("param1=");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?param1=", (Object)config.getUrl().toString());
        }

        public void testMakingUrl9() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.parseArguments("param1");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html?param1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl10() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.parseArguments("");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org:80/index.html", (Object)config.getUrl().toString());
        }
    }
}

