/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public class HTTPSamplerFull
extends HTTPSampler {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    protected static String utfEncodingName;
    protected URL baseUrl;

    public HTTPSamplerFull() {
        log.debug("Start : HTTPSamplerFull");
        log.debug("End   : HTTPSamplerFull");
    }

    public SampleResult sample(Entry e) {
        log.debug("Start : HTTPSamplerFull sample");
        SampleResult res = super.sample(e);
        if (log.isDebugEnabled()) {
            log.debug("Main page loading time - " + res.getTime());
        }
        String displayName = res.getSampleLabel();
        Document html = null;
        try {
            this.baseUrl = this.getUrl();
            if (log.isDebugEnabled()) {
                log.debug("baseUrl - " + this.baseUrl.toString());
            }
            html = (Document)HTTPSamplerFull.getDOM(new String(res.getResponseData()));
        }
        catch (SAXException se) {
            log.error("Error parsing document - " + se);
            res.setResponseData(se.toString().getBytes());
            res.setResponseCode("Non HTTP response code");
            res.setResponseMessage("Non HTTP response message");
            res.setSuccessful(false);
            return res;
        }
        catch (MalformedURLException mfue) {
            log.error("Error creating URL '" + displayName + "'");
            log.error("MalformedURLException - " + mfue);
            res.setResponseData(mfue.toString().getBytes());
            res.setResponseCode("Non HTTP response code");
            res.setResponseMessage("Non HTTP response message");
            res.setSuccessful(false);
            return res;
        }
        HashSet uniqueURLs = new HashSet();
        this.parseNodes(html, "img", false, "src", uniqueURLs, res);
        this.parseNodes(html, "applet", false, "code", uniqueURLs, res);
        this.parseNodes(html, "input", true, "src", uniqueURLs, res);
        this.parseNodes(html, "body", false, "background", uniqueURLs, res);
        if (log.isDebugEnabled()) {
            log.debug("Total time - " + res.getTime());
        }
        log.debug("End   : HTTPSamplerFull sample");
        return res;
    }

    protected void parseNodes(Document html, String htmlTag, boolean type, String srcTag, Set uniques, SampleResult res) {
        log.debug("Start : HTTPSamplerFull parseNodes");
        NodeList nodeList = html.getElementsByTagName(htmlTag);
        SampleResult binRes = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            boolean uniqueBinary = true;
            Node tempNode = nodeList.item(i);
            if (log.isDebugEnabled()) {
                log.debug("'" + htmlTag + "' tag: " + tempNode);
            }
            NamedNodeMap nnm = tempNode.getAttributes();
            Node namedItem = null;
            if (type) {
                namedItem = nnm.getNamedItem("type");
                if (namedItem == null) {
                    log.debug("namedItem 'null' - ignoring");
                    break;
                }
                String inputType = namedItem.getNodeValue();
                if (log.isDebugEnabled()) {
                    log.debug("Input type - " + inputType);
                }
                if (inputType == null || !inputType.equalsIgnoreCase("image")) {
                    log.debug("type != 'image' - ignoring");
                    break;
                }
            }
            binRes = new SampleResult();
            namedItem = nnm.getNamedItem(srcTag);
            if (namedItem != null) {
                String binUrlStr = namedItem.getNodeValue();
                binRes.setSampleLabel(this.baseUrl + "," + binUrlStr);
                URL binUrl = null;
                try {
                    binUrl = new URL(this.baseUrl, binUrlStr);
                }
                catch (MalformedURLException mfue) {
                    log.error("Error creating URL '" + this.baseUrl + " , " + binUrlStr + "'");
                    log.error("MalformedURLException - " + mfue);
                    binRes.setResponseData(mfue.toString().getBytes());
                    binRes.setResponseCode("Non HTTP response code");
                    binRes.setResponseMessage("Non HTTP response message");
                    binRes.setSuccessful(false);
                    res.addSubResult(binRes);
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Binary url - " + binUrlStr);
                    log.debug("Full Binary url - " + binUrl);
                }
                binRes.setSampleLabel(binUrl.toString());
                uniqueBinary = uniques.add(binUrl.toString());
                if (uniqueBinary) {
                    try {
                        this.loadBinary(binUrl, binRes);
                    }
                    catch (IOException ioe) {
                        log.error("Error reading from URL - " + ioe);
                        binRes.setResponseData(ioe.toString().getBytes());
                        binRes.setResponseCode("Non HTTP response code");
                        binRes.setResponseMessage("Non HTTP response message");
                        binRes.setSuccessful(false);
                    }
                    log.debug("Adding result");
                    res.addSubResult(binRes);
                    res.setTime(res.getTime() + binRes.getTime());
                } else if (log.isDebugEnabled()) {
                    log.debug("Skipping duplicate - " + binUrl);
                }
            }
            ++i;
        }
        log.debug("End   : HTTPSamplerFull parseNodes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadBinary(URL url, SampleResult res) throws IOException {
        byte[] byArray;
        log.debug("Start : loadBinary");
        byte[] ret = new byte[]{};
        res.setSamplerData((TestElement)new HTTPSampler(url));
        try {
            this.conn = this.setupConnection(url, "GET");
            this.connect();
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("loadBinary : error in setupConnection " + ioe);
            }
            throw ioe;
        }
        try {
            int errorLevel;
            long time = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("loadBinary : start time - " + time);
            }
            if ((errorLevel = this.getErrorLevel(this.conn, res)) == 2) {
                ret = this.readResponse(this.conn);
                res.setSuccessful(true);
                long endTime = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug("loadBinary : end   time - " + endTime);
                }
                res.setTime(endTime - time);
            } else {
                res.setSuccessful(false);
                int responseCode = this.conn.getResponseCode();
                String responseMsg = this.conn.getResponseMessage();
                log.error("loadBinary : failed code - " + responseCode);
                log.error("loadBinary : failed message - " + responseMsg);
            }
            if (log.isDebugEnabled()) {
                log.debug("loadBinary : binary - " + ret[0] + ret[1]);
                log.debug("loadBinary : loadTime - " + res.getTime());
            }
            log.debug("End   : loadBinary");
            res.setResponseData(ret);
            res.setDataType("bin");
            byArray = ret;
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                String connection = this.conn.getHeaderField("Connection");
                if (connection == null || connection.equalsIgnoreCase("close")) {
                    this.conn.disconnect();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
        try {
            String connection = this.conn.getHeaderField("Connection");
            if (connection == null || connection.equalsIgnoreCase("close")) {
                this.conn.disconnect();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return byArray;
    }

    protected int getErrorLevel(HttpURLConnection conn, SampleResult res) {
        log.debug("Start : getErrorLevel");
        int errorLevel = 2;
        try {
            int responseCode = conn.getResponseCode();
            String responseMessage = conn.getResponseMessage();
            errorLevel = responseCode / 100;
            res.setResponseCode(String.valueOf(responseCode));
            res.setResponseMessage(responseMessage);
            if (log.isDebugEnabled()) {
                log.debug("getErrorLevel : responseCode - " + responseCode);
                log.debug("getErrorLevel : responseMessage - " + responseMessage);
            }
        }
        catch (Exception e2) {
            log.error("getErrorLevel : " + conn.getHeaderField(0));
            log.error("getErrorLevel : " + conn.getHeaderFieldKey(0));
            log.error("getErrorLevel : Error getting response code for HttpUrlConnection - ", (Throwable)e2);
            res.setResponseData(e2.toString().getBytes());
            res.setResponseCode("Non HTTP response code");
            res.setResponseMessage("Non HTTP response message");
            res.setSuccessful(false);
        }
        log.debug("End   : getErrorLevel");
        return errorLevel;
    }

    public Object clone() {
        HTTPSamplerFull newSampler = new HTTPSamplerFull();
        this.configureClone((TestElement)newSampler);
        return newSampler;
    }

    protected static Tidy getParser() {
        log.debug("Start : getParser");
        Tidy tidy = new Tidy();
        tidy.setCharEncoding(3);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        if (log.isDebugEnabled()) {
            log.debug("getParser : tidy parser created - " + tidy);
        }
        log.debug("End   : getParser");
        return tidy;
    }

    protected static Node getDOM(String text) throws SAXException {
        log.debug("Start : getDOM");
        try {
            Document node = HTTPSamplerFull.getParser().parseDOM((InputStream)new ByteArrayInputStream(text.getBytes(HTTPSamplerFull.getUTFEncodingName())), null);
            if (log.isDebugEnabled()) {
                log.debug("node : " + node);
            }
            log.debug("End   : getDOM");
            return node;
        }
        catch (UnsupportedEncodingException e) {
            log.error("getDOM1 : Unsupported encoding exception - " + e);
            log.debug("End   : getDOM");
            throw new RuntimeException("UTF-8 encoding failed - " + e);
        }
    }

    protected static String getUTFEncodingName() {
        log.debug("Start : getUTFEncodingName");
        if (utfEncodingName == null) {
            String versionNum = System.getProperty("java.version");
            if (log.isDebugEnabled()) {
                log.debug("getUTFEncodingName : version = " + versionNum);
            }
            utfEncodingName = versionNum.startsWith("1.1") ? "UTF8" : "UTF-8";
        }
        if (log.isDebugEnabled()) {
            log.debug("getUTFEncodingName : Encoding = " + utfEncodingName);
        }
        log.debug("End   : getUTFEncodingName");
        return utfEncodingName;
    }

    public static class Test
    extends TestCase {
        private HTTPSamplerFull hsf;
        private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.test");

        public Test(String name) {
            super(name);
        }

        protected void setUp() {
            log.debug("Start : setUp1");
            this.hsf = new HTTPSamplerFull();
            this.hsf.setMethod("GET");
            this.hsf.setProtocol("file");
            this.hsf.setPath("HTTPSamplerFullTestFile.txt");
            log.debug("End   : setUp1");
        }

        public void testGetUTFEncodingName() {
            log.debug("Start : testGetUTFEncodingName");
            String javaVersion = System.getProperty("java.version");
            System.setProperty("java.version", "1.1");
            Assert.assertEquals((Object)"UTF8", (Object)HTTPSamplerFull.getUTFEncodingName());
            utfEncodingName = null;
            System.setProperty("java.version", "1.2");
            Assert.assertEquals((Object)"UTF-8", (Object)HTTPSamplerFull.getUTFEncodingName());
            System.setProperty("java.version", javaVersion);
            log.debug("End   : testGetUTFEncodingName");
        }

        public void testGetUrlConfig() {
            log.debug("Start : testGetUrlConfig");
            Assert.assertEquals((Object)"GET", (Object)this.hsf.getMethod());
            Assert.assertEquals((Object)"file", (Object)this.hsf.getProtocol());
            Assert.assertEquals((Object)"HTTPSamplerFullTestFile.txt", (Object)this.hsf.getPath());
            log.debug("End   : testGetUrlConfig");
        }

        public void testSampleMain() {
            log.debug("Start : testSampleMain");
            String fileInput = "<html>\n\n<title>\n  A simple applet\n</title>\n<body background=\"back.jpg\" vlink=\"#dd0000\" link=\"#0000ff\">\n<center>\n<h2>   A simple applet\n</h2>\n<br>\n<br>\n<table>\n<td width = 20>\n<td width = 500 align = left>\n<img src=\"/tomcat.gif\">\n<img src=\"/tomcat.gif\">\n<a href=\"NervousText.java\"> Read my code <a>\n<p><applet code=NervousText.class width=400 height=200>\n</applet>\n<p><applet code=NervousText.class width=400 height=200>\n</applet>\n</table>\n<form>\n  <input type=\"image\" src=\"/tomcat-power.gif\">\n</form>\n<form>\n  <input type=\"image\" src=\"/tomcat-power.gif\">\n</form>\n</body>\n</html>\n";
            byte[] bytes = fileInput.getBytes();
            try {
                FileOutputStream fos = new FileOutputStream("HTTPSamplerFullTestFile.txt");
                fos.write(bytes);
                fos.close();
            }
            catch (IOException ioe) {
                Assert.fail((String)("Cannot create HTTPSamplerFullTestFile.txt in current directory for testing - " + ioe));
            }
            Assert.assertNull((String)"Cannot think of way to test sample", null);
            log.debug("End   : testSampleMain");
        }

        protected void tearDown() {
            log.debug("Start : tearDown");
            this.hsf = null;
            log.debug("End   : tearDown");
        }
    }
}

