/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Iterator;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.protocol.http.config.MultipartUrlConfig;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;

public class PostWriter {
    protected static final String BOUNDARY = "---------------------------7d159c1302d0y0";
    protected static final byte[] CRLF;
    protected static int fudge;
    protected static String encoding;

    public void sendPostData(URLConnection connection, HTTPSampler sampler) throws IOException {
        String filename = sampler.getFilename();
        if (filename != null && filename.trim().length() > 0) {
            OutputStream out = connection.getOutputStream();
            this.writeln(out, "-----------------------------7d159c1302d0y0");
            Iterator args = sampler.getArguments().iterator();
            while (args.hasNext()) {
                Argument arg = (Argument)args.next();
                this.writeFormMultipartStyle(out, arg.getName(), (String)arg.getValue());
                this.writeln(out, "-----------------------------7d159c1302d0y0");
            }
            this.writeFileToURL(out, filename, sampler.getFileField(), this.getFileStream(filename), sampler.getMimetype());
            this.writeln(out, "-----------------------------7d159c1302d0y0--");
            out.flush();
            out.close();
        } else {
            String postData = sampler.getQueryString();
            PrintWriter out = new PrintWriter(connection.getOutputStream());
            out.print(postData);
            out.flush();
        }
    }

    public void setHeaders(URLConnection connection, HTTPSampler sampler) throws IOException {
        ((HttpURLConnection)connection).setRequestMethod("POST");
        String filename = sampler.getFileField();
        if (filename != null && filename.trim().length() > 0) {
            connection.setRequestProperty("Content-type", "multipart/form-data; boundary=---------------------------7d159c1302d0y0");
            connection.setDoOutput(true);
            connection.setDoInput(true);
        } else {
            String postData = sampler.getQueryString();
            connection.setRequestProperty("Content-length", "" + postData.length());
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
        }
    }

    private InputStream getFileStream(String filename) throws IOException {
        return new BufferedInputStream(new FileInputStream(filename));
    }

    private String getContentLength(MultipartUrlConfig config) {
        long size = 0L;
        size += (long)(BOUNDARY.length() + 2);
        Iterator iter = config.getArguments().iterator();
        while (iter.hasNext()) {
            Argument item = (Argument)iter.next();
            size += (long)(item.getName().length() + item.getValue().toString().length());
            size += (long)(CRLF.length * 4);
            size += (long)(BOUNDARY.length() + 2);
            size += 39L;
        }
        size += new File(config.getFilename()).length();
        size += (long)(CRLF.length * 5);
        size += (long)(BOUNDARY.length() + 2);
        size += (long)this.encode(config.getFileFieldName()).length();
        size += (long)this.encode(config.getFilename()).length();
        size += (long)config.getMimeType().length();
        size += 66L;
        return Long.toString(size += (long)(2 + CRLF.length * 1));
    }

    /*
     * WARNING - void declaration
     */
    private void writeFileToURL(OutputStream out, String filename, String fieldname, InputStream in, String mimetype) throws IOException {
        int read;
        this.writeln(out, "Content-Disposition: form-data; name=\"" + this.encode(fieldname) + "\"; filename=\"" + this.encode(filename) + "\"");
        this.writeln(out, "Content-Type: " + mimetype);
        out.write(CRLF);
        byte[] buf = new byte[102400];
        while ((read = in.read(buf)) > 0) {
            void var7_7;
            out.write(buf, 0, (int)var7_7);
        }
        out.write(CRLF);
        in.close();
    }

    private void writeFormMultipartStyle(OutputStream out, String name, String value) throws IOException {
        this.writeln(out, "Content-Disposition: form-data; name=\"" + name + "\"");
        out.write(CRLF);
        this.writeln(out, value);
    }

    private String encode(String value) {
        StringBuffer newValue = new StringBuffer();
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\\') {
                newValue.append("\\\\");
            } else {
                newValue.append(chars[i]);
            }
            ++i;
        }
        return newValue.toString();
    }

    private void write(OutputStream out, String value) throws UnsupportedEncodingException, IOException {
        out.write(value.getBytes(encoding));
    }

    private void writeln(OutputStream out, String value) throws UnsupportedEncodingException, IOException {
        out.write(value.getBytes(encoding));
        out.write(CRLF);
    }

    static {
        BOUNDARY = BOUNDARY;
        CRLF = new byte[]{13, 10};
        fudge = -20;
        encoding = "iso-8859-1";
    }
}

