/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;

public class HTTPArgument
extends Argument
implements Serializable {
    private static final String ENCODED_NAME = "HTTPArgument.encoded_name";
    private static final String ENCODED_VALUE = "HTTPArgument.encoded_value";
    private static final String ALWAYS_ENCODE = "HTTPArgument.always_encode";

    public HTTPArgument(String name, Object value, Object metadata) {
        this(name, value, false);
        this.setMetaData(metadata);
    }

    private void encodeName(String name) {
        if (this.getAlwaysEncode()) {
            name = URLEncoder.encode(name);
        }
        this.setProperty(ENCODED_NAME, name);
    }

    public void setAlwaysEncode(boolean ae) {
        this.setProperty(ALWAYS_ENCODE, new Boolean(ae));
    }

    public boolean getAlwaysEncode() {
        return this.getPropertyAsBoolean(ALWAYS_ENCODE);
    }

    private void encodeValue(Object value) {
        if (value != null) {
            if (this.getAlwaysEncode()) {
                value = URLEncoder.encode(value.toString());
            }
            this.setProperty(ENCODED_VALUE, value.toString());
        }
    }

    public HTTPArgument(String name, Object value) {
        this(name, value, false);
    }

    public HTTPArgument(String name, Object value, boolean alreadyEncoded) {
        this.setAlwaysEncode(true);
        if (alreadyEncoded) {
            try {
                this.setName(URLDecoder.decode(name));
            }
            catch (IllegalArgumentException e) {
                this.setName(name);
            }
            try {
                this.setValue(URLDecoder.decode(value.toString()));
            }
            catch (IllegalArgumentException e) {
                this.setValue(value.toString());
            }
            this.setProperty(ENCODED_NAME, name);
            this.setProperty(ENCODED_VALUE, value.toString());
        } else {
            this.setName(name);
            this.setValue(value);
        }
    }

    public void setProperty(String key, Object value) {
        if (value == null || !value.equals(this.getProperty(key))) {
            if ("Argument.name".equals(key)) {
                if (value == null) {
                    this.encodeName("");
                } else {
                    this.encodeName(value.toString());
                }
            } else if ("Argument.value".equals(key)) {
                this.encodeValue(value);
            }
            super.setProperty(key, value);
        }
    }

    public HTTPArgument(String name, Object value, Object metaData, boolean alreadyEncoded) {
        this(name, value, alreadyEncoded);
        this.setMetaData(metaData);
    }

    public HTTPArgument(Argument arg) {
        this(arg.getName(), arg.getValue(), arg.getMetaData());
    }

    public HTTPArgument() {
    }

    public void setName(String newName) {
        if (newName == null || !newName.equals(this.getName())) {
            super.setName(newName);
        }
    }

    public String getEncodedValue() {
        return this.getPropertyAsString(ENCODED_VALUE);
    }

    public String getEncodedName() {
        return this.getPropertyAsString(ENCODED_NAME);
    }

    public void setValue(Object newValue) {
        if (newValue == null || !newValue.equals(this.getValue())) {
            super.setValue(newValue);
        }
    }

    public static void convertArgumentsToHTTP(Arguments args) {
        LinkedList<Argument> newArguments = new LinkedList<Argument>();
        Iterator iter = args.getArguments().iterator();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next();
            if (!(arg instanceof HTTPArgument)) {
                newArguments.add(new HTTPArgument(arg));
                continue;
            }
            newArguments.add(arg);
        }
        args.removeAllArguments();
        args.setArguments(newArguments);
    }

    static {
        ENCODED_NAME = ENCODED_NAME;
        ENCODED_VALUE = ENCODED_VALUE;
        ALWAYS_ENCODE = ALWAYS_ENCODE;
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testCloning() throws Exception {
            HTTPArgument arg = new HTTPArgument("name.?", "value_ here");
            Assert.assertEquals((Object)"name.%3F", (Object)arg.getEncodedName());
            Assert.assertEquals((Object)"value_+here", (Object)arg.getEncodedValue());
            HTTPArgument clone = (HTTPArgument)arg.clone();
            Assert.assertEquals((Object)"name.%3F", (Object)clone.getEncodedName());
            Assert.assertEquals((Object)"value_+here", (Object)clone.getEncodedValue());
        }

        public void testConversion() throws Exception {
            Arguments args = new Arguments();
            args.addArgument("name.?", (Object)"value_ here");
            args.addArgument("name$of property", (Object)"value_.+");
            HTTPArgument.convertArgumentsToHTTP(args);
            List argList = args.getArguments();
            HTTPArgument httpArg = (HTTPArgument)argList.get(0);
            Assert.assertEquals((Object)"name.%3F", (Object)httpArg.getEncodedName());
            Assert.assertEquals((Object)"value_+here", (Object)httpArg.getEncodedValue());
            httpArg = (HTTPArgument)argList.get(1);
            Assert.assertEquals((Object)"name%24of+property", (Object)httpArg.getEncodedName());
            Assert.assertEquals((Object)"value_.%2B", (Object)httpArg.getEncodedValue());
        }
    }
}

