/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HashTree
implements Serializable,
Map {
    private static Logger log = LoggingManager.getLoggerFor("jorphan.collections");
    protected Map data = new HashMap();

    public HashTree() {
    }

    public HashTree(Object key) {
        this.data.put(key, new HashTree());
    }

    public void putAll(Map map) {
        if (!(map instanceof HashTree)) {
            throw new UnsupportedOperationException("can only putAll other HashTree objects");
        }
        this.add((HashTree)map);
    }

    public Set entrySet() {
        return this.data.entrySet();
    }

    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    public Object put(Object key, Object value) {
        Object previous = this.data.get(key);
        this.add(key, value);
        return previous;
    }

    public void clear() {
        this.data.clear();
    }

    public Collection values() {
        return this.data.values();
    }

    public void add(Object key, HashTree subTree) {
        this.add(key);
        this.getTree(key).add(subTree);
    }

    public void add(HashTree newTree) {
        Iterator iter = newTree.list().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            this.add(item);
            this.getTree(item).add(newTree.getTree(item));
        }
    }

    public HashTree(Collection keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.data.put(it.next(), new HashTree());
        }
    }

    public HashTree(Object[] keys) {
        int x = 0;
        while (x < keys.length) {
            this.data.put(keys[x], new HashTree());
            ++x;
        }
    }

    public boolean containsKey(Object o) {
        return this.data.containsKey(o);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void set(Object key, Object value) {
        this.data.put(key, this.createNewTree(value));
    }

    public void set(Object key, HashTree t) {
        this.data.put(key, t);
    }

    public void set(Object key, Object[] values) {
        this.data.put(key, this.createNewTree(Arrays.asList(values)));
    }

    public void set(Object key, Collection values) {
        this.data.put(key, this.createNewTree(values));
    }

    public void set(Object[] treePath, Object[] values) {
        if (treePath != null && values != null) {
            this.set(Arrays.asList(treePath), Arrays.asList(values));
        }
    }

    public void set(Object[] treePath, Collection values) {
        if (treePath != null) {
            this.set(Arrays.asList(treePath), values);
        }
    }

    public void set(Collection treePath, Object[] values) {
        HashTree tree = this.addTreePath(treePath);
        tree.set(Arrays.asList(values));
    }

    public void set(Collection values) {
        Iterator iter = this.list().iterator();
        while (iter.hasNext()) {
            this.remove(iter.next());
        }
        this.add(values);
    }

    public void set(Collection treePath, Collection values) {
        HashTree tree = this.addTreePath(treePath);
        tree.set(values);
    }

    public void add(Object key) {
        if (!this.data.containsKey(key)) {
            this.data.put(key, this.createNewTree());
        }
    }

    public void add(Object[] keys) {
        int x = 0;
        while (x < keys.length) {
            this.add(keys[x]);
            ++x;
        }
    }

    public void add(Collection keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public void add(Object key, Object value) {
        this.add(key);
        this.getTree(key).add(value);
    }

    public void add(Object key, Object[] values) {
        this.add(key);
        this.getTree(key).add(values);
    }

    public void add(Object key, Collection values) {
        this.add(key);
        this.getTree(key).add(values);
    }

    public void add(Object[] treePath, Object[] values) {
        if (treePath != null) {
            this.add((Collection)Arrays.asList(treePath), (Collection)Arrays.asList(values));
        }
    }

    public void add(Object[] treePath, Collection values) {
        if (treePath != null) {
            this.add((Collection)Arrays.asList(treePath), values);
        }
    }

    public void add(Collection treePath, Object[] values) {
        HashTree tree = this.addTreePath(treePath);
        tree.add(Arrays.asList(values));
    }

    public void add(Collection treePath, Object value) {
        HashTree tree = this.addTreePath(treePath);
        tree.add(value);
    }

    public void add(Collection treePath, Collection values) {
        HashTree tree = this.addTreePath(treePath);
        tree.add(values);
    }

    protected HashTree addTreePath(Collection treePath) {
        HashTree tree = this;
        Iterator iter = treePath.iterator();
        while (iter.hasNext()) {
            Object temp = iter.next();
            tree.add(temp);
            tree = tree.getTree(temp);
        }
        return tree;
    }

    public HashTree getTree(Object key) {
        return (HashTree)this.data.get(key);
    }

    public Object get(Object key) {
        return this.getTree(key);
    }

    public HashTree getTree(Object[] treePath) {
        if (treePath != null) {
            return this.getTree(Arrays.asList(treePath));
        }
        return this;
    }

    public Object clone() {
        HashTree newTree = new HashTree();
        newTree.data = (Map)((HashMap)this.data).clone();
        return newTree;
    }

    protected HashTree createNewTree() {
        return new HashTree();
    }

    protected HashTree createNewTree(Object key) {
        return new HashTree(key);
    }

    protected HashTree createNewTree(Collection values) {
        return new HashTree(values);
    }

    public HashTree getTree(Collection treePath) {
        return this.getTreePath(treePath);
    }

    public Collection list() {
        return this.data.keySet();
    }

    public Collection list(Object key) {
        HashTree temp = (HashTree)this.data.get(key);
        if (temp != null) {
            return temp.list();
        }
        return null;
    }

    public Object remove(Object key) {
        return this.data.remove(key);
    }

    public Collection list(Object[] treePath) {
        if (treePath != null) {
            return this.list(Arrays.asList(treePath));
        }
        return this.list();
    }

    public Collection list(Collection treePath) {
        return this.getTreePath(treePath).list();
    }

    public void replace(Object currentKey, Object newKey) {
        HashTree tree = this.getTree(currentKey);
        this.data.remove(currentKey);
        this.data.put(newKey, tree);
    }

    public Object[] getArray() {
        return this.data.keySet().toArray();
    }

    public Object[] getArray(Object key) {
        return this.getTree(key).getArray();
    }

    public Object[] getArray(Object[] treePath) {
        if (treePath != null) {
            return this.getArray(Arrays.asList(treePath));
        }
        return this.getArray();
    }

    public Object[] getArray(Collection treePath) {
        HashTree tree = this.getTreePath(treePath);
        return tree.getArray();
    }

    protected HashTree getTreePath(Collection treePath) {
        HashTree tree = this;
        Iterator iter = treePath.iterator();
        while (iter.hasNext()) {
            Object temp = iter.next();
            log.debug("Getting tree for " + temp);
            tree = tree.getTree(temp);
        }
        return tree;
    }

    public int hashCode() {
        return this.data.hashCode() * 7;
    }

    public boolean equals(Object o) {
        boolean flag = true;
        if (o instanceof HashTree) {
            HashTree oo = (HashTree)o;
            Iterator it = this.data.keySet().iterator();
            while (it.hasNext()) {
                if (oo.containsKey(it.next())) continue;
                flag = false;
                break;
            }
            if (flag) {
                it = this.data.keySet().iterator();
                while (it.hasNext()) {
                    Object temp = it.next();
                    flag = this.get(temp).equals(oo.get(temp));
                    if (flag) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public Set keySet() {
        return this.data.keySet();
    }

    public HashTree search(Object key) {
        HashTree temp;
        block2: {
            block1: {
                temp = null;
                if (!this.data.containsKey(key)) break block1;
                temp = (HashTree)this.data.get(key);
                break block2;
            }
            Iterator it = this.list().iterator();
            if (!it.hasNext()) break block2;
            if (temp == null) {
                temp = ((HashTree)it.next()).search(key);
            }
        }
        return temp;
    }

    void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public int size() {
        return this.data.size();
    }

    public void traverse(HashTreeTraverser visitor) {
        Iterator iter = this.list().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            visitor.addNode(item, this.getTree(item));
            this.getTree(item).traverseInto(visitor);
        }
    }

    private void traverseInto(HashTreeTraverser visitor) {
        Iterator iter = this.list().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            visitor.addNode(item, this.getTree(item));
            this.getTree(item).traverseInto(visitor);
        }
        if (this.list().size() == 0) {
            visitor.processPath();
        }
        visitor.subtractNode();
    }

    public String toString() {
        ConvertToString converter = new ConvertToString();
        this.traverse(converter);
        return converter.toString();
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testAdd1() throws Exception {
            List<String> treePath = Arrays.asList("1", "2", "3", "4");
            HashTree tree = new HashTree();
            log.debug("treePath = " + treePath);
            tree.add(treePath, (Object)new String("value"));
            log.debug("Now treePath = " + treePath);
            log.debug(tree.toString());
            Assert.assertEquals((int)1, (int)tree.list(treePath).size());
            Assert.assertEquals((Object)"value", (Object)tree.getArray(treePath)[0]);
        }
    }

    private class ConvertToString
    implements HashTreeTraverser {
        StringBuffer string = new StringBuffer(this.getClass().getName());
        StringBuffer spaces = new StringBuffer();
        int depth = 0;

        private ConvertToString() {
        }

        public void addNode(Object key, HashTree subTree) {
            ++this.depth;
            this.string.append("\n" + this.getSpaces() + "{" + key);
        }

        public void subtractNode() {
            --this.depth;
            this.string.append("\n" + this.getSpaces() + "}");
        }

        public void processPath() {
        }

        public String toString() {
            return this.string.toString();
        }

        private String getSpaces() {
            if (this.spaces.length() < this.depth * 2) {
                while (this.spaces.length() < this.depth * 2) {
                    this.spaces.append("  ");
                }
            } else if (this.spaces.length() > this.depth * 2) {
                this.spaces.setLength(this.depth * 2);
            }
            return this.spaces.toString();
        }
    }
}

