/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jorphan.collections.HashTree;

public class ListedHashTree
extends HashTree
implements Serializable,
Cloneable {
    private List order;

    public ListedHashTree() {
        this.data = new HashMap();
        this.order = new LinkedList();
    }

    public Object clone() {
        ListedHashTree newTree = new ListedHashTree();
        newTree.data = (Map)((HashMap)this.data).clone();
        newTree.order = (List)((LinkedList)this.order).clone();
        return newTree;
    }

    public ListedHashTree(Object key) {
        this.data = new HashMap();
        this.order = new LinkedList();
        this.data.put(key, new ListedHashTree());
        this.order.add(key);
    }

    public ListedHashTree(Collection keys) {
        this.data = new HashMap();
        this.order = new LinkedList();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            this.data.put(temp, new ListedHashTree());
            this.order.add(temp);
        }
    }

    public ListedHashTree(Object[] keys) {
        this.data = new HashMap();
        this.order = new LinkedList();
        int x = 0;
        while (x < keys.length) {
            this.data.put(keys[x], new ListedHashTree());
            this.order.add(keys[x]);
            ++x;
        }
    }

    public void set(Object key, Object value) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, value);
    }

    public void set(Object key, HashTree t) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, t);
    }

    public void set(Object key, Object[] values) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, values);
    }

    public void set(Object key, Collection values) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, values);
    }

    public void replace(Object currentKey, Object newKey) {
        HashTree tree = this.getTree(currentKey);
        this.data.remove(currentKey);
        this.data.put(newKey, tree);
        this.order.set(this.order.indexOf(currentKey), newKey);
    }

    public HashTree createNewTree() {
        return new ListedHashTree();
    }

    public HashTree createNewTree(Object key) {
        return new ListedHashTree(key);
    }

    public HashTree createNewTree(Collection values) {
        return new ListedHashTree(values);
    }

    public void add(Object key) {
        if (!this.data.containsKey(key)) {
            this.data.put(key, this.createNewTree());
            this.order.add(key);
        }
    }

    public Collection list() {
        return this.order;
    }

    public Object remove(Object key) {
        this.order.remove(key);
        return this.data.remove(key);
    }

    public Object[] getArray() {
        return this.order.toArray();
    }

    public int hashCode() {
        return this.data.hashCode() * 7 + 3;
    }

    public boolean equals(Object o) {
        boolean flag = true;
        if (o instanceof ListedHashTree) {
            ListedHashTree oo = (ListedHashTree)o;
            Iterator it = this.order.iterator();
            Iterator it2 = oo.order.iterator();
            if (this.size() != oo.size()) {
                flag = false;
            }
            while (it.hasNext() && it2.hasNext() && flag) {
                if (it.next().equals(it2.next())) continue;
                flag = false;
            }
            if (flag) {
                it = this.order.iterator();
                while (it.hasNext() && flag) {
                    Object temp = it.next();
                    flag = this.get(temp).equals(oo.get(temp));
                }
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public Set keySet() {
        return this.data.keySet();
    }

    public int size() {
        return this.data.size();
    }

    void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testAddObjectAndTree() throws Exception {
            ListedHashTree tree = new ListedHashTree("key");
            ListedHashTree newTree = new ListedHashTree("value");
            tree.add((Object)"key", newTree);
            Assert.assertEquals((int)tree.list().size(), (int)1);
            Assert.assertEquals((Object)"key", (Object)tree.getArray()[0]);
            Assert.assertEquals((int)1, (int)tree.getTree("key").list().size());
            Assert.assertEquals((int)0, (int)tree.getTree("key").getTree("value").size());
            Assert.assertEquals((Object)tree.getTree("key").getArray()[0], (Object)"value");
            Test.assertNotNull((Object)tree.getTree("key").get("value"));
        }
    }
}

