/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SortedHashTree
extends HashTree
implements Serializable {
    private static Logger log = LoggingManager.getLoggerFor("jorphan.collections");

    public SortedHashTree() {
        this.data = new TreeMap();
    }

    public SortedHashTree(Object key) {
        this.data = new TreeMap();
        this.data.put(key, new SortedHashTree());
    }

    public SortedHashTree(Collection keys) {
        this.data = new TreeMap();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.data.put(it.next(), new SortedHashTree());
        }
    }

    public SortedHashTree(Object[] keys) {
        this.data = new TreeMap();
        int x = 0;
        while (x < keys.length) {
            this.data.put(keys[x], new SortedHashTree());
            ++x;
        }
    }

    public HashTree createNewTree() {
        return new SortedHashTree();
    }

    public HashTree createNewTree(Object key) {
        return new SortedHashTree(key);
    }

    public HashTree createNewTree(Collection values) {
        return new SortedHashTree(values);
    }

    public Object clone() {
        SortedHashTree newTree = new SortedHashTree();
        newTree.data = (Map)((HashMap)this.data).clone();
        return newTree;
    }
}

