/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.apache.jorphan.gui.JLabeledField;

public class JLabeledTextArea
extends JPanel
implements JLabeledField {
    private JLabel mLabel = new JLabel();
    private JTextArea mTextArea = new JTextArea(4, 40);
    private ArrayList mChangeListeners = new ArrayList(3);

    public JLabeledTextArea() {
        this.init();
    }

    public List getComponentList() {
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        comps.add(this.mLabel);
        comps.add(this.mTextArea);
        return comps;
    }

    public JLabeledTextArea(String pLabel, Document docModel) {
        this.mLabel.setText(pLabel);
        if (docModel != null) {
            this.setDocumentModel(docModel);
        }
        this.init();
    }

    public void setDocumentModel(Document docModel) {
        this.mTextArea.setDocument(docModel);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.mTextArea.setLineWrap(true);
        this.mTextArea.setWrapStyleWord(true);
        this.mTextArea.addFocusListener(new FocusListener(){
            String oldValue = "";

            public void focusLost(FocusEvent pFocusEvent) {
                if (!this.oldValue.equals(JLabeledTextArea.this.mTextArea.getText())) {
                    JLabeledTextArea.this.notifyChangeListeners();
                }
            }

            public void focusGained(FocusEvent pFocusEvent) {
                this.oldValue = JLabeledTextArea.this.mTextArea.getText();
            }
        });
        this.mTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.mLabel, "North");
        this.add((Component)this.mTextArea, "Center");
    }

    public void setLabel(String pLabel) {
        this.mLabel.setText(pLabel);
    }

    public void setText(String pText) {
        this.mTextArea.setText(pText);
    }

    public String getText() {
        return this.mTextArea.getText();
    }

    public String getLabel() {
        return this.mLabel.getText();
    }

    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    public void removeChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.remove(pChangeListener);
    }

    private void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        int index = 0;
        while (index < this.mChangeListeners.size()) {
            ((ChangeListener)this.mChangeListeners.get(index)).stateChanged(ce);
            ++index;
        }
    }
}

