/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jorphan.gui.JLabeledField;

public class JLabeledTextField
extends JPanel
implements JLabeledField {
    private JLabel mLabel = new JLabel();
    protected JTextField mTextField;
    private ArrayList mChangeListeners = new ArrayList(3);

    public JLabeledTextField() {
        this.createTextField(20);
        this.init();
    }

    public List getComponentList() {
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        comps.add(this.mLabel);
        comps.add(this.mTextField);
        return comps;
    }

    protected void createTextField(int size) {
        this.mTextField = new JTextField(size);
    }

    public JLabeledTextField(String pLabel) {
        this.createTextField(20);
        this.mLabel.setText(pLabel);
        this.init();
    }

    public JLabeledTextField(String pLabel, int size) {
        this.createTextField(size);
        this.mLabel.setText(pLabel);
        this.init();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.mTextField.setEnabled(enable);
    }

    private void init() {
        this.setLayout(new FlowLayout(0));
        this.mTextField.addFocusListener(new FocusListener(){
            String oldValue = "";

            public void focusLost(FocusEvent pFocusEvent) {
                if (!this.oldValue.equals(JLabeledTextField.this.mTextField.getText())) {
                    JLabeledTextField.this.notifyChangeListeners();
                }
            }

            public void focusGained(FocusEvent pFocusEvent) {
                this.oldValue = JLabeledTextField.this.mTextField.getText();
            }
        });
        this.add(this.mLabel);
        this.add(this.mTextField);
    }

    public void setLabel(String pLabel) {
        this.mLabel.setText(pLabel);
    }

    public void setText(String pText) {
        this.mTextField.setText(pText);
    }

    public String getText() {
        return this.mTextField.getText();
    }

    public String getLabel() {
        return this.mLabel.getText();
    }

    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    public void removeChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.remove(pChangeListener);
    }

    protected void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        int index = 0;
        while (index < this.mChangeListeners.size()) {
            ((ChangeListener)this.mChangeListeners.get(index)).stateChanged(ce);
            ++index;
        }
    }
}

