/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TextFile
extends File {
    private static transient Logger log = LoggingManager.getLoggerFor("jorphan.io");

    public TextFile(File filename) {
        super(filename.toString());
    }

    public TextFile() {
        super("");
    }

    public TextFile(String filename) {
        super(filename);
    }

    public void setText(String body) {
        try {
            FileWriter writer = new FileWriter(this);
            writer.write(body);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException ioe) {
            log.error("", (Throwable)ioe);
        }
    }

    public String getText() {
        String lineEnd = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this));
            String line = "NOTNULL";
            while (line != null) {
                line = br.readLine();
                if (line == null) continue;
                sb.append(line + lineEnd);
            }
        }
        catch (IOException ioe) {
            log.error("", (Throwable)ioe);
        }
        return sb.toString();
    }
}

