/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.logging;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.NullOutputLogTarget;
import org.apache.log.output.io.WriterTarget;

public class LoggingManager {
    private static PatternFormatter format = new PatternFormatter("%{time:MM/dd/yyyy h:mm:ss a} %{priority} - %{category}: %{message} %{throwable}\n");
    private static LogTarget target;
    public static final String LOG_FILE = "log_file";
    public static final String LOG_PRIORITY = "log_level";
    private static LoggingManager logManager;

    private LoggingManager() {
        target = new NullOutputLogTarget();
    }

    public static LoggingManager getLogManager() {
        return logManager;
    }

    public static void initializeLogging(Map properties) {
        if (logManager == null) {
            logManager = new LoggingManager();
        }
        LoggingManager.setLoggingLevels(properties, (String)properties.get(LOG_FILE));
    }

    private static void setLoggingLevels(Map appProperties, String logFile) {
        WriterTarget tempTarget = null;
        try {
            tempTarget = new WriterTarget((Writer)new FileWriter(logFile), (Formatter)format);
        }
        catch (Exception e) {
            target = new WriterTarget((Writer)new PrintWriter(System.out), (Formatter)format);
        }
        Iterator names = appProperties.keySet().iterator();
        while (names.hasNext()) {
            String prop = (String)names.next();
            if (!prop.startsWith(LOG_PRIORITY)) continue;
            String name = prop.substring(LOG_PRIORITY.length() + 1);
            logManager.setPriority(Priority.getPriorityForName((String)((String)appProperties.get(prop))), name);
            if (tempTarget != null) {
                logManager.setTarget((LogTarget)tempTarget, name);
                continue;
            }
            logManager.setTarget(target, name);
        }
    }

    public static Logger getLoggerFor(String category) {
        return Hierarchy.getDefaultHierarchy().getLoggerFor(category);
    }

    public void setPriority(Priority p, String category) {
        Hierarchy.getDefaultHierarchy().getLoggerFor(category).setPriority(p);
    }

    public void setTarget(LogTarget target, String category) {
        Logger logger = LoggingManager.getLoggerFor(category);
        logger.setLogTargets(new LogTarget[]{target});
    }

    public void setTarget(Writer targetFile) {
        if (target == null) {
            target = new WriterTarget(targetFile, (Formatter)format);
            Hierarchy.getDefaultHierarchy().setDefaultLogTarget((LogTarget)new WriterTarget(targetFile, (Formatter)format));
        } else {
            if (target instanceof WriterTarget) {
                ((WriterTarget)target).close();
            }
            target = new WriterTarget(targetFile, (Formatter)format);
            Hierarchy.getDefaultHierarchy().setDefaultLogTarget((LogTarget)new WriterTarget(targetFile, (Formatter)format));
        }
    }

    static {
        LOG_FILE = LOG_FILE;
        LOG_PRIORITY = LOG_PRIORITY;
        logManager = null;
        HashMap<String, String> initProps = new HashMap<String, String>();
        initProps.put("log_level.jorphan", "ERROR");
        LoggingManager.initializeLogging(initProps);
    }
}

