/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.test.UnitTestManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AllTests {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.test");
    static /* synthetic */ Class class$junit$framework$TestCase;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("You must specify a comma-delimited list of paths to search for unit tests");
            System.exit(0);
        }
        AllTests.initializeLogging(args);
        AllTests.initializeManager(args);
        try {
            TestSuite suite = AllTests.suite(args[0]);
            PrintStream out = new PrintStream(new FileOutputStream("testresults.txt"));
            TestRunner runner = new TestRunner(out);
            TestRunner.run((Test)suite);
            out.close();
        }
        catch (FileNotFoundException e) {
            log.error("", (Throwable)e);
        }
        System.exit(0);
    }

    protected static void initializeLogging(String[] args) {
        if (args.length >= 2) {
            Properties props = new Properties();
            try {
                System.out.println("setting up logging props using file: " + args[1]);
                props.load(new FileInputStream(args[1]));
                LoggingManager.initializeLogging(props);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void initializeManager(String[] args) {
        if (args.length >= 3) {
            try {
                UnitTestManager um = (UnitTestManager)Class.forName(args[2]).newInstance();
                um.initializeProperties(args[1]);
            }
            catch (Exception e) {
                System.out.println("Couldn't create: " + args[2]);
                e.printStackTrace();
            }
        }
    }

    private static TestSuite suite(String searchPaths) {
        TestSuite suite = new TestSuite();
        try {
            Iterator classes = ClassFinder.findClassesThatExtend(JOrphanUtils.split(searchPaths, ","), new Class[]{class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = AllTests.class$("junit.framework.TestCase")) : class$junit$framework$TestCase}, true).iterator();
            while (classes.hasNext()) {
                String name = (String)classes.next();
                try {
                    suite.addTest((Test)new TestSuite(Class.forName(name)));
                }
                catch (Exception ex) {
                    log.error("error adding test :" + ex);
                }
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("", (Throwable)e);
        }
        return suite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

