/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.net.Authenticator;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.ProxyAuthenticator;
import org.apache.jmeter.engine.RemoteJMeterEngineImpl;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Load;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.plugin.JMeterPlugin;
import org.apache.jmeter.plugin.PluginManager;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMeter
implements JMeterPlugin {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter");
    private static final int PROPFILE_OPT = 112;
    private static final int TESTFILE_OPT = 116;
    private static final int LOGFILE_OPT = 108;
    private static final int NONGUI_OPT = 110;
    protected static final int HELP_OPT = 104;
    protected static final int VERSION_OPT = 118;
    protected static final int SERVER_OPT = 115;
    protected static final int PROXY_HOST = 72;
    protected static final int PROXY_PORT = 80;
    protected static final int PROXY_USERNAME = 117;
    protected static final int PROXY_PASSWORD = 97;
    protected static final CLOptionDescriptor[] options;
    static /* synthetic */ Class class$org$apache$jmeter$control$gui$TestPlanGui;
    static /* synthetic */ Class class$org$apache$jmeter$timers$gui$AbstractTimerGui;
    static /* synthetic */ Class class$org$apache$jmeter$threads$gui$ThreadGroupGui;
    static /* synthetic */ Class class$org$apache$jmeter$visualizers$gui$AbstractVisualizer;
    static /* synthetic */ Class class$org$apache$jmeter$config$gui$AbstractConfigGui;
    static /* synthetic */ Class class$org$apache$jmeter$config$gui$AbstractModifierGui;
    static /* synthetic */ Class class$org$apache$jmeter$config$gui$AbstractResponseBasedModifierGui;
    static /* synthetic */ Class class$org$apache$jmeter$control$gui$AbstractControllerGui;
    static /* synthetic */ Class class$org$apache$jmeter$control$gui$WorkBenchGui;
    static /* synthetic */ Class class$org$apache$jmeter$samplers$gui$AbstractSamplerGui;

    public void startGui(CLOption testFile) throws IllegalUserActionException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        PluginManager.install(this, true);
        JMeterTreeModel treeModel = new JMeterTreeModel();
        JMeterTreeListener treeLis = new JMeterTreeListener(treeModel);
        treeLis.setActionHandler(ActionRouter.getInstance());
        GuiPackage guiPack = GuiPackage.getInstance(treeLis, treeModel);
        MainFrame main = new MainFrame(ActionRouter.getInstance(), treeModel, treeLis);
        main.setTitle("Apache JMeter");
        main.setIconImage(JMeterUtils.getImage("jmeter.jpg").getImage());
        ComponentUtil.centerComponentInWindow((Component)main, (int)80);
        main.show();
        ActionRouter.getInstance().actionPerformed(new ActionEvent(main, 1, "add_all"));
        if (testFile != null) {
            try {
                File f = new File(testFile.getArgument());
                FileInputStream reader = new FileInputStream(f);
                HashTree tree = SaveService.loadSubTree(reader);
                new Load().insertLoadedTree(1, tree);
            }
            catch (Exception e) {
                log.error("Failure loading test file", (Throwable)e);
            }
        }
    }

    public void start(String[] args) {
        CLArgsParser parser = new CLArgsParser(args, options);
        if (null != parser.getErrorString()) {
            System.err.println("Error: " + parser.getErrorString());
            return;
        }
        try {
            this.initializeProperties(parser);
            this.setProxy(parser);
            if (parser.getArgumentById(118) != null) {
                System.out.println("Apache JMeter, Copyright (c) 2002 The Apache Software Foundation");
                System.out.println("Version " + JMeterUtils.getJMeterVersion());
            } else if (parser.getArgumentById(104) != null) {
                System.out.println(JMeterUtils.getResourceFileAsText("org/apache/jmeter/help.txt"));
            } else if (parser.getArgumentById(115) != null) {
                this.startServer();
            } else if (parser.getArgumentById(110) == null) {
                this.startGui(parser.getArgumentById(116));
            } else {
                this.startNonGui(parser.getArgumentById(116), parser.getArgumentById(108));
            }
        }
        catch (IllegalUserActionException e) {
            System.out.println(e.getMessage());
            System.out.println("Incorrect Usage");
            System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("An error occurred: " + e.getMessage());
            System.exit(-1);
        }
    }

    private void setProxy(CLArgsParser parser) throws IllegalUserActionException {
        if (parser.getArgumentById(117) != null) {
            if (parser.getArgumentById(97) != null) {
                Authenticator.setDefault(new ProxyAuthenticator(parser.getArgumentById(117).getArgument(), parser.getArgumentById(97).getArgument()));
            } else {
                Authenticator.setDefault(new ProxyAuthenticator(parser.getArgumentById(117).getArgument(), ""));
            }
        }
        if (parser.getArgumentById(72) != null && parser.getArgumentById(80) != null) {
            System.setProperty("http.proxyHost", parser.getArgumentById(72).getArgument());
            System.setProperty("https.proxyHost", parser.getArgumentById(72).getArgument());
            System.setProperty("http.proxyPort", parser.getArgumentById(80).getArgument());
            System.setProperty("https.proxyPort", parser.getArgumentById(80).getArgument());
        } else if (parser.getArgumentById(72) != null || parser.getArgumentById(80) != null) {
            throw new IllegalUserActionException(JMeterUtils.getResString("proxy_cl_error"));
        }
    }

    private void initializeProperties(CLArgsParser parser) {
        if (parser.getArgumentById(112) != null) {
            JMeterUtils.getProperties(parser.getArgumentById(112).getArgument());
        } else {
            JMeterUtils.getProperties(NewDriver.getJMeterDir() + File.separator + "bin" + File.separator + "jmeter.properties");
        }
        JMeterUtils.setJMeterHome(NewDriver.getJMeterDir());
    }

    public void startServer() {
        try {
            RemoteJMeterEngineImpl engine = new RemoteJMeterEngineImpl();
            while (true) {
                Thread.sleep(Long.MAX_VALUE);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return;
        }
    }

    public void startNonGui(CLOption testFile, CLOption logFile) throws IllegalUserActionException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        JMeter driver = new JMeter();
        PluginManager.install(this, false);
        if (testFile == null) {
            throw new IllegalUserActionException();
        }
        if (logFile == null) {
            driver.run(testFile.getArgument(), null);
        } else {
            driver.run(testFile.getArgument(), logFile.getArgument());
        }
    }

    private void run(String testFile, String logFile) {
        FileInputStream reader = null;
        try {
            File f = new File(testFile);
            if (!f.exists() || !f.isFile()) {
                JMeter.println("Could not open " + testFile);
                return;
            }
            reader = new FileInputStream(f);
            HashTree tree = SaveService.loadSubTree(reader);
            if (logFile != null) {
                ResultCollector logger = new ResultCollector();
                logger.setFilename(logFile);
                tree.add(tree.getArray()[0], (Object)logger);
            }
            tree.add(tree.getArray()[0], (Object)new ListenToTest());
            JMeter.println("Created the tree successfully");
            StandardJMeterEngine engine = new StandardJMeterEngine();
            engine.configure(tree);
            JMeter.println("Starting the test");
            engine.runTest();
        }
        catch (Exception e) {
            System.out.println("Error in NonGUIDriver" + e.getMessage());
            log.error("", (Throwable)e);
        }
    }

    private static void println(String str) {
        System.out.println(str);
    }

    public String[][] getIconMappings() {
        return new String[][]{{(class$org$apache$jmeter$control$gui$TestPlanGui == null ? (class$org$apache$jmeter$control$gui$TestPlanGui = JMeter.class$("org.apache.jmeter.control.gui.TestPlanGui")) : class$org$apache$jmeter$control$gui$TestPlanGui).getName(), "org/apache/jmeter/images/beaker.gif"}, {(class$org$apache$jmeter$timers$gui$AbstractTimerGui == null ? (class$org$apache$jmeter$timers$gui$AbstractTimerGui = JMeter.class$("org.apache.jmeter.timers.gui.AbstractTimerGui")) : class$org$apache$jmeter$timers$gui$AbstractTimerGui).getName(), "org/apache/jmeter/images/timer.gif"}, {(class$org$apache$jmeter$threads$gui$ThreadGroupGui == null ? (class$org$apache$jmeter$threads$gui$ThreadGroupGui = JMeter.class$("org.apache.jmeter.threads.gui.ThreadGroupGui")) : class$org$apache$jmeter$threads$gui$ThreadGroupGui).getName(), "org/apache/jmeter/images/thread.gif"}, {(class$org$apache$jmeter$visualizers$gui$AbstractVisualizer == null ? (class$org$apache$jmeter$visualizers$gui$AbstractVisualizer = JMeter.class$("org.apache.jmeter.visualizers.gui.AbstractVisualizer")) : class$org$apache$jmeter$visualizers$gui$AbstractVisualizer).getName(), "org/apache/jmeter/images/meter.png"}, {(class$org$apache$jmeter$config$gui$AbstractConfigGui == null ? (class$org$apache$jmeter$config$gui$AbstractConfigGui = JMeter.class$("org.apache.jmeter.config.gui.AbstractConfigGui")) : class$org$apache$jmeter$config$gui$AbstractConfigGui).getName(), "org/apache/jmeter/images/testtubes.png"}, {(class$org$apache$jmeter$config$gui$AbstractModifierGui == null ? (class$org$apache$jmeter$config$gui$AbstractModifierGui = JMeter.class$("org.apache.jmeter.config.gui.AbstractModifierGui")) : class$org$apache$jmeter$config$gui$AbstractModifierGui).getName(), "org/apache/jmeter/images/testtubes.gif"}, {(class$org$apache$jmeter$config$gui$AbstractResponseBasedModifierGui == null ? (class$org$apache$jmeter$config$gui$AbstractResponseBasedModifierGui = JMeter.class$("org.apache.jmeter.config.gui.AbstractResponseBasedModifierGui")) : class$org$apache$jmeter$config$gui$AbstractResponseBasedModifierGui).getName(), "org/apache/jmeter/images/testtubes.gif"}, {(class$org$apache$jmeter$control$gui$AbstractControllerGui == null ? (class$org$apache$jmeter$control$gui$AbstractControllerGui = JMeter.class$("org.apache.jmeter.control.gui.AbstractControllerGui")) : class$org$apache$jmeter$control$gui$AbstractControllerGui).getName(), "org/apache/jmeter/images/knob.gif"}, {(class$org$apache$jmeter$control$gui$WorkBenchGui == null ? (class$org$apache$jmeter$control$gui$WorkBenchGui = JMeter.class$("org.apache.jmeter.control.gui.WorkBenchGui")) : class$org$apache$jmeter$control$gui$WorkBenchGui).getName(), "org/apache/jmeter/images/clipboard.gif"}, {(class$org$apache$jmeter$samplers$gui$AbstractSamplerGui == null ? (class$org$apache$jmeter$samplers$gui$AbstractSamplerGui = JMeter.class$("org.apache.jmeter.samplers.gui.AbstractSamplerGui")) : class$org$apache$jmeter$samplers$gui$AbstractSamplerGui).getName(), "org/apache/jmeter/images/pipet.png"}};
    }

    public String[][] getResourceBundles() {
        return new String[0][];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROPFILE_OPT = 112;
        TESTFILE_OPT = 116;
        LOGFILE_OPT = 108;
        NONGUI_OPT = 110;
        HELP_OPT = 104;
        VERSION_OPT = 118;
        SERVER_OPT = 115;
        PROXY_HOST = 72;
        PROXY_PORT = 80;
        PROXY_USERNAME = 117;
        PROXY_PASSWORD = 97;
        options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print this message and exit"), new CLOptionDescriptor("version", 8, 118, "print the version information and exit"), new CLOptionDescriptor("propfile", 2, 112, "the jmeter property file to use"), new CLOptionDescriptor("testfile", 2, 116, "the jmeter test(.jmx) file to run"), new CLOptionDescriptor("logfile", 2, 108, "the file to log samples to"), new CLOptionDescriptor("logfile", 8, 110, "run JMeter in nongui mode"), new CLOptionDescriptor("server", 8, 115, "run the JMeter server"), new CLOptionDescriptor("proxyHost", 2, 72, "Set a proxy server for JMeter to use"), new CLOptionDescriptor("proxyPort", 2, 80, "Set proxy server port for JMeter to use"), new CLOptionDescriptor("username", 2, 117, "Set username for proxy server that JMeter is to use"), new CLOptionDescriptor("password", 2, 97, "Set password for proxy server that JMeter is to use")};
    }

    private class ListenToTest
    implements TestListener,
    Runnable {
        private ListenToTest() {
        }

        public void testEnded(String host) {
        }

        public void testEnded() {
            Thread stopSoon = new Thread(this);
            stopSoon.start();
        }

        public void testStarted(String host) {
        }

        public void testStarted() {
            log.info(JMeterUtils.getResString("running_test"));
        }

        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }
}

