/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.util.JMeterUtils;

public class Arguments
extends ConfigTestElement
implements Serializable {
    public static String[] COLUMN_NAMES = new String[]{JMeterUtils.getResString("name"), JMeterUtils.getResString("value"), JMeterUtils.getResString("metadata")};
    private static final String ARGUMENTS = "Arguments.arguments";

    public Arguments() {
        this.setProperty(ARGUMENTS, new ArrayList());
    }

    public List getArguments() {
        return (List)this.getProperty(ARGUMENTS);
    }

    public void setArguments(List arguments) {
        this.setProperty(ARGUMENTS, arguments);
    }

    public Map getArgumentsAsMap() {
        Iterator iter = this.getArguments().iterator();
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next();
            argMap.put(arg.getName(), arg.getValue());
        }
        return argMap;
    }

    public void addArgument(String name, Object value) {
        this.getArguments().add(new Argument(name, value, null));
    }

    public void addArgument(Argument arg) {
        this.getArguments().add(arg);
    }

    public void addArgument(String name, Object value, Object metadata) {
        this.getArguments().add(new Argument(name, value, metadata));
    }

    public Iterator iterator() {
        return this.getArguments().iterator();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        Iterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next();
            if (arg.getMetaData() == null) {
                str.append(arg.getName() + "=" + arg.getValue());
            } else {
                str.append(arg.getName() + arg.getMetaData() + arg.getValue());
            }
            if (!iter.hasNext()) continue;
            str.append("&");
        }
        return str.toString();
    }

    public void removeArgument(int row) {
        if (row < this.getArguments().size()) {
            this.getArguments().remove(row);
        }
    }

    public void removeArgument(Argument arg) {
        this.getArguments().remove(arg);
    }

    public void removeArgument(String argName) {
        Iterator iter = this.getArguments().iterator();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next();
            if (!arg.getName().equals(argName)) continue;
            iter.remove();
        }
    }

    public void removeAllArguments() {
        if (this.getArguments().size() > 0) {
            this.getArguments().clear();
        }
    }

    public void addEmptyArgument() {
        this.getArguments().add(new Argument("", "", null));
    }

    public int getArgumentCount() {
        return this.getArguments().size();
    }

    public Argument getArgument(int row) {
        Argument argument = null;
        if (row < this.getArguments().size()) {
            argument = (Argument)this.getArguments().get(row);
        }
        return argument;
    }

    static {
        ARGUMENTS = ARGUMENTS;
    }
}

