/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.Data;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ArgumentsPanel
extends AbstractConfigGui
implements FocusListener,
ActionListener,
CellEditorListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    JTable table;
    JButton add;
    JButton delete;
    protected PowerTableModel tableModel;
    String name;
    JLabel tableLabel;
    private static String ADD = "add";
    private static String DELETE = "delete";
    static /* synthetic */ Class class$java$lang$String;

    public ArgumentsPanel() {
        this(JMeterUtils.getResString("paramtable"));
    }

    public void editingCanceled(ChangeEvent e) {
    }

    public void editingStopped(ChangeEvent e) {
    }

    public ArgumentsPanel(String label) {
        this.tableLabel = new JLabel(label);
        this.init();
    }

    protected JTable getTable() {
        return this.table;
    }

    protected JButton getDeleteButton() {
        return this.delete;
    }

    protected JButton getAddButton() {
        return this.add;
    }

    public Collection getMenuCategories() {
        return null;
    }

    public String getStaticLabel() {
        return "Argument List";
    }

    public TestElement createTestElement() {
        Data model = this.tableModel.getData();
        Arguments args = new Arguments();
        model.reset();
        while (model.next()) {
            args.addArgument((String)model.getColumnValue(Arguments.COLUMN_NAMES[0]), model.getColumnValue(Arguments.COLUMN_NAMES[1]));
        }
        this.configureTestElement(args);
        return (TestElement)args.clone();
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof Arguments) {
            this.tableModel.clearData();
            Iterator iter = ((Arguments)el).getArguments().iterator();
            while (iter.hasNext()) {
                Argument arg = (Argument)iter.next();
                this.tableModel.addRow(new Object[]{arg.getName(), arg.getValue()});
            }
        }
        this.checkDeleteStatus();
    }

    public void focusLost(FocusEvent e) {
        log.debug("Focus lost on table");
        this.stopTableEditing();
    }

    public void focusGained(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(DELETE)) {
            this.deleteArgument();
        } else if (action.equals(ADD)) {
            this.addArgument();
        }
    }

    protected void deleteArgument() {
        int rowSelected;
        if (this.table.isEditing()) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.cancelCellEditing();
        }
        if ((rowSelected = this.table.getSelectedRow()) >= 0) {
            this.tableModel.removeRow(rowSelected);
            this.tableModel.fireTableDataChanged();
            if (this.tableModel.getRowCount() == 0) {
                this.delete.setEnabled(false);
            } else {
                int rowToSelect = rowSelected;
                if (rowSelected >= this.tableModel.getRowCount()) {
                    rowToSelect = rowSelected - 1;
                }
                this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }

    protected void addArgument() {
        this.stopTableEditing();
        this.tableModel.addNewRow();
        this.tableModel.fireTableDataChanged();
        this.delete.setEnabled(true);
        int rowToSelect = this.tableModel.getRowCount() - 1;
        this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }

    private void stopTableEditing() {
        if (this.table.isEditing()) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.stopCellEditing();
        }
    }

    public void addInnerPanel() {
        this.initializeTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setEnabled(true);
        this.table.addFocusListener(this);
        this.table.setCellSelectionEnabled(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        JScrollPane scroller = new JScrollPane(this.table);
        Dimension tableDim = scroller.getPreferredSize();
        tableDim.height = 70;
        scroller.setPreferredSize(tableDim);
        scroller.setColumnHeaderView(this.table.getTableHeader());
        this.add = new JButton(JMeterUtils.getResString("add"));
        this.add.setActionCommand(ADD);
        this.add.setEnabled(true);
        this.delete = new JButton(JMeterUtils.getResString("delete"));
        this.delete.setActionCommand(DELETE);
        this.checkDeleteStatus();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add.addActionListener(this);
        this.delete.addActionListener(this);
        buttonPanel.add(this.add);
        buttonPanel.add(this.delete);
        this.add((Component)scroller, "Center");
        this.add((Component)buttonPanel, "South");
    }

    protected void initializeTableModel() {
        this.tableModel = new PowerTableModel(new String[]{Arguments.COLUMN_NAMES[0], Arguments.COLUMN_NAMES[1]}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ArgumentsPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ArgumentsPanel.class$("java.lang.String")) : class$java$lang$String});
    }

    protected void checkDeleteStatus() {
        if (this.tableModel.getRowCount() == 0) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        labelPanel.add(this.tableLabel);
        this.add((Component)labelPanel, "North");
        this.addInnerPanel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testArgumentCreation() throws Exception {
            ArgumentsPanel gui = new ArgumentsPanel();
            gui.tableModel.addNewRow();
            gui.tableModel.setValueAt("howdy", 0, 0);
            gui.tableModel.setValueAt("doody", 0, 1);
            Assert.assertEquals((Object)"=", (Object)((Argument)((Arguments)gui.createTestElement()).getArguments().get(0)).getMetaData());
        }
    }
}

