/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class LoginConfigGui
extends AbstractConfigGui {
    JTextField username = new JTextField(15);
    JTextField password = new JPasswordField(15);
    private boolean displayName = true;

    public LoginConfigGui() {
        this(true);
    }

    public LoginConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString("Login Config Element");
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.username.setText((String)element.getProperty("ConfigTestElement.username"));
        this.password.setText((String)element.getProperty("ConfigTestElement.password"));
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.configureTestElement(element);
        element.setProperty("ConfigTestElement.username", this.username.getText());
        element.setProperty("ConfigTestElement.password", this.password.getText());
        return element;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(1, 2));
        if (this.displayName) {
            this.add(this.getNamePanel());
        }
        this.add(this.createUsernamePanel());
        this.add(this.createPasswordPanel());
    }

    private JPanel createUsernamePanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(JMeterUtils.getResString("username")));
        panel.add(this.username);
        return panel;
    }

    private JPanel createPasswordPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(JMeterUtils.getResString("password")));
        panel.add(this.password);
        return panel;
    }
}

