/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.PerThreadClonable;
import org.apache.jmeter.testelement.TestElement;

public class GenericController
extends AbstractTestElement
implements Controller,
Serializable,
PerThreadClonable {
    protected List subControllersAndSamplers = new ArrayList();
    protected int current;
    protected Iterator controlIt;
    private List configs = new LinkedList();
    private boolean returnedNull = false;
    private boolean done = false;
    private boolean timeForNext = false;
    private List assertions = new LinkedList();

    public boolean isNextFirst() {
        return this.current == 0;
    }

    protected List getConfigElements() {
        return this.configs;
    }

    private void addConfigElement(TestElement el) {
        this.configs.add(el);
    }

    public void initialize() {
        this.resetCurrent();
    }

    public void reInitialize() {
        this.resetCurrent();
    }

    protected void removeCurrentController() {
        this.subControllersAndSamplers.remove(this.current);
    }

    protected void resetCurrent() {
        this.current = 0;
    }

    protected void incrementCurrent() {
        ++this.current;
    }

    protected boolean hasNextAtEnd() {
        return false;
    }

    protected void nextAtEnd() {
        this.resetCurrent();
    }

    public boolean hasNext() {
        boolean retVal;
        TestElement controller = this.getCurrentController();
        if (controller == null) {
            retVal = this.hasNextAtEnd();
        } else if (controller instanceof Controller) {
            if (((Controller)controller).hasNext()) {
                retVal = true;
            } else {
                this.currentHasNextIsFalse();
                retVal = this.hasNext();
            }
        } else {
            retVal = true;
        }
        if (!retVal) {
            this.reInitialize();
        }
        return retVal;
    }

    protected void currentHasNextIsFalse() {
        if (((Controller)this.getCurrentController()).isDone()) {
            this.removeCurrentController();
        } else {
            this.incrementCurrent();
        }
    }

    protected boolean shortCircuitIsDone() {
        return this.done;
    }

    protected void setShortCircuit(boolean done) {
        this.done = done;
    }

    public boolean isDone() {
        if (this.shortCircuitIsDone()) {
            return true;
        }
        boolean isdone = true;
        Iterator iter = this.subControllersAndSamplers.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof Sampler) {
                return false;
            }
            boolean bl = isdone = isdone && ((Controller)item).isDone();
        }
        this.setShortCircuit(isdone);
        return isdone;
    }

    protected TestElement getCurrentController() {
        if (this.current < this.subControllersAndSamplers.size()) {
            return (TestElement)this.subControllersAndSamplers.get(this.current);
        }
        return null;
    }

    protected List getSubControllers() {
        return this.subControllersAndSamplers;
    }

    public void addTestElement(TestElement child) {
        if (child instanceof Controller || child instanceof Sampler) {
            this.addController(child);
        }
    }

    private void addController(TestElement child) {
        this.subControllersAndSamplers.add(child);
    }

    public Sampler next() {
        TestElement controller = this.getCurrentController();
        if (controller == null) {
            this.nextAtEnd();
            return this.next();
        }
        if (controller instanceof Sampler) {
            this.incrementCurrent();
            return (Sampler)controller;
        }
        Controller c = (Controller)controller;
        if (c.hasNext()) {
            Sampler s = c.next();
            return s;
        }
        if (c.isDone()) {
            this.removeCurrentController();
            return this.next();
        }
        this.incrementCurrent();
        return this.next();
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            GenericController controller = new GenericController();
            GenericController sub_1 = new GenericController();
            sub_1.addTestElement(this.makeSampler("one"));
            sub_1.addTestElement(this.makeSampler("two"));
            controller.addTestElement(sub_1);
            controller.addTestElement(this.makeSampler("three"));
            GenericController sub_2 = new GenericController();
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement(this.makeSampler("four"));
            sub_3.addTestElement(this.makeSampler("five"));
            sub_3.addTestElement(this.makeSampler("six"));
            sub_2.addTestElement(sub_3);
            sub_2.addTestElement(this.makeSampler("seven"));
            controller.addTestElement(sub_2);
            String[] order = new String[]{"one", "two", "three", "four", "five", "six", "seven"};
            int counter = 7;
            int i = 0;
            while (i < 2) {
                Assert.assertEquals((int)7, (int)counter);
                counter = 0;
                while (controller.hasNext()) {
                    Sampler sampler = controller.next();
                    Assert.assertEquals((Object)order[counter++], (Object)sampler.getProperty("TestElement.name"));
                }
                ++i;
            }
        }

        private TestElement makeSampler(String name) {
            TestSampler s = new TestSampler();
            s.setName(name);
            return s;
        }

        class TestSampler
        extends AbstractSampler {
            TestSampler() {
            }

            public void addCustomTestElement(TestElement t) {
            }

            public SampleResult sample(Entry e) {
                return null;
            }
        }
    }
}

