/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;

public class LoopController
extends GenericController
implements Serializable {
    private static final String LOOPS = "LoopController.loops";
    private static final String CONTINUE_FOREVER = "LoopController.continue_forever";
    private int loopCount = 0;

    public LoopController() {
        this.setContinueForever(true);
    }

    public void setLoops(int loops) {
        this.setProperty(LOOPS, new Integer(loops));
    }

    public int getLoops() {
        return this.getPropertyAsInt(LOOPS);
    }

    public void setContinueForever(boolean forever) {
        this.setProperty(CONTINUE_FOREVER, new Boolean(forever));
    }

    public boolean getContinueForever() {
        return this.getPropertyAsBoolean(CONTINUE_FOREVER);
    }

    public void initialize() {
        super.initialize();
        this.resetLoopCount();
    }

    public void reInitialize() {
        super.reInitialize();
        this.resetLoopCount();
    }

    protected void incrementLoopCount() {
        ++this.loopCount;
    }

    protected void resetLoopCount() {
        if (!this.getContinueForever() && this.getLoops() > -1) {
            this.setShortCircuit(true);
        } else {
            this.loopCount = 0;
        }
    }

    protected boolean hasNextAtEnd() {
        this.resetCurrent();
        this.incrementLoopCount();
        if (this.endOfLoop()) {
            return false;
        }
        return this.hasNext();
    }

    protected void nextAtEnd() {
        this.resetCurrent();
        this.incrementLoopCount();
    }

    private boolean endOfLoop() {
        return (!this.getContinueForever() || this.getLoops() > -1) && this.loopCount >= this.getLoops();
    }

    static {
        LOOPS = LOOPS;
        CONTINUE_FOREVER = CONTINUE_FOREVER;
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            GenericController controller = new GenericController();
            GenericController sub_1 = new GenericController();
            sub_1.addTestElement(this.makeSampler("one"));
            sub_1.addTestElement(this.makeSampler("two"));
            controller.addTestElement(sub_1);
            controller.addTestElement(this.makeSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement(this.makeSampler("four"));
            sub_3.addTestElement(this.makeSampler("five"));
            sub_3.addTestElement(this.makeSampler("six"));
            sub_2.addTestElement(sub_3);
            sub_2.addTestElement(this.makeSampler("seven"));
            controller.addTestElement(sub_2);
            String[] order = new String[]{"one", "two", "three", "four", "five", "six", "seven", "four", "five", "six", "seven", "four", "five", "six", "seven"};
            int counter = 15;
            int i = 0;
            while (i < 2) {
                Assert.assertEquals((int)15, (int)counter);
                counter = 0;
                while (controller.hasNext()) {
                    Sampler sampler = controller.next();
                    Assert.assertEquals((Object)order[counter++], (Object)sampler.getProperty("TestElement.name"));
                }
                ++i;
            }
        }

        private TestElement makeSampler(String name) {
            TestSampler s = new TestSampler();
            s.setName(name);
            return s;
        }

        class TestSampler
        extends AbstractSampler {
            TestSampler() {
            }

            public void addCustomTestElement(TestElement t) {
            }

            public SampleResult sample(Entry e) {
                return null;
            }
        }
    }
}

