/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class LoopControlPanel
extends AbstractControllerGui
implements KeyListener,
ActionListener {
    JCheckBox infinite;
    JTextField loops;
    private boolean displayName = true;
    private static String INFINITE = "Infinite Field";
    private static String LOOPS = "Loops Field";

    public LoopControlPanel() {
        this(true);
    }

    public LoopControlPanel(boolean displayName) {
        this.displayName = displayName;
        this.init();
        this.setState(1);
    }

    public void configure(TestElement element) {
        this.setName((String)element.getProperty("TestElement.name"));
        if (element instanceof LoopController) {
            this.setState(((LoopController)element).getLoops());
        } else {
            this.setState(1);
        }
    }

    public TestElement createTestElement() {
        LoopController lc = new LoopController();
        this.configureTestElement(lc);
        if (this.loops.getText().length() > 0) {
            lc.setLoops(Integer.parseInt(this.loops.getText()));
        } else {
            lc.setLoops(-1);
        }
        return lc;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.infinite.isSelected()) {
            this.loops.setText("");
            this.loops.setEnabled(false);
        } else {
            this.loops.setEnabled(true);
            new FocusRequester(this.loops);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        block3: {
            String temp = e.getComponent().getName();
            if (temp.equals(LOOPS)) {
                try {
                    Integer.parseInt(this.loops.getText());
                }
                catch (NumberFormatException ex) {
                    if (this.loops.getText().length() <= 0) break block3;
                    JOptionPane.showMessageDialog(this, "You must enter a valid number", "Invalid data", 2);
                    this.loops.setText("");
                }
            }
        }
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString("loop_controller_title");
    }

    private void init() {
        if (this.displayName) {
            this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
            JPanel mainPanel = new JPanel();
            EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
            mainPanel.setBorder(margin);
            mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString("loop_controller_title"));
            Font curFont = panelTitleLabel.getFont();
            int curFontSize = curFont.getSize();
            panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
            mainPanel.add(panelTitleLabel);
            mainPanel.add(this.getNamePanel());
            mainPanel.add(this.createLoopCountPanel());
            this.add(mainPanel);
        } else {
            this.add(this.createLoopCountPanel());
        }
    }

    private JPanel createLoopCountPanel() {
        JPanel loopPanel = new JPanel();
        JLabel loopsLabel = new JLabel(JMeterUtils.getResString("iterator_num"));
        loopPanel.add(loopsLabel);
        this.loops = new JTextField(5);
        loopPanel.add(this.loops);
        this.loops.setName(LOOPS);
        this.loops.addKeyListener(this);
        this.loops.setText("1");
        this.infinite = new JCheckBox(JMeterUtils.getResString("infinite"));
        this.infinite.setActionCommand(INFINITE);
        this.infinite.addActionListener(this);
        loopPanel.add(this.infinite);
        return loopPanel;
    }

    private void setState(int loopCount) {
        if (loopCount <= -1) {
            this.infinite.setSelected(true);
            this.loops.setEnabled(false);
            this.loops.setText("");
        } else {
            this.infinite.setSelected(false);
            this.loops.setEnabled(true);
            this.loops.setText("" + loopCount);
        }
    }
}

