/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.NamePanel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class WorkBenchGui
extends JPanel
implements JMeterGUIComponent {
    NamePanel namePanel = new NamePanel();
    private JMeterTreeNode node;

    public WorkBenchGui() {
        this.setName(this.getStaticLabel());
        this.init();
    }

    public Collection getMenuCategories() {
        return null;
    }

    public String getName() {
        return this.namePanel.getName();
    }

    public void setName(String name) {
        this.namePanel.setName(name);
    }

    public TestElement createTestElement() {
        WorkBench wb = new WorkBench();
        wb.setProperty("TestElement.name", this.namePanel.getName());
        wb.setProperty("TestElement.gui_class", this.getClass().getName());
        wb.setProperty("TestElement.test_class", wb.getClass().getName());
        return wb;
    }

    public void configure(TestElement element) {
        this.namePanel.configure(element);
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenu addMenu = MenuFactory.makeMenus(new String[]{"menu_logic_controller", "menu_generative_controller", "menu_config_element", "menu_non_test_elements"}, JMeterUtils.getResString("Add"), "Add");
        menu.add(addMenu);
        MenuFactory.addEditMenu(menu, false);
        MenuFactory.addFileMenu(menu);
        return menu;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString("workbench");
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString("workbench_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add(this.namePanel);
        this.add(mainPanel);
    }

    public void setNode(JMeterTreeNode node) {
        this.node = node;
        this.namePanel.setNode(node);
    }
}

