/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.RemoteJMeterEngine;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jorphan.collections.HashTree;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RemoteJMeterEngineImpl
extends UnicastRemoteObject
implements RemoteJMeterEngine {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");
    JMeterEngine backingEngine;

    public RemoteJMeterEngineImpl() throws RemoteException {
        try {
            this.backingEngine = new StandardJMeterEngine(InetAddress.getLocalHost().getHostName());
            Naming.rebind("JMeterEngine", this);
        }
        catch (Exception ex) {
            log.error("rmiregistry needs to be running to start JMeter in server mode", (Throwable)ex);
        }
    }

    public void setHost(String host) {
        this.backingEngine.setHost(host);
    }

    public void configure(HashTree testTree) throws RemoteException {
        this.backingEngine.configure(testTree);
    }

    public void runTest() throws RemoteException, JMeterEngineException {
        this.backingEngine.runTest();
    }

    public void reset() throws RemoteException {
        this.backingEngine.reset();
    }

    public void stopTest() throws RemoteException {
        this.backingEngine.stopTest();
    }

    public static void main(String[] args) {
        try {
            RemoteJMeterEngineImpl engine = new RemoteJMeterEngineImpl();
            while (true) {
                Thread.sleep(Long.MAX_VALUE);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return;
        }
    }
}

