/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.testelement.PerThreadClonable;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;

public class TreeCloner
implements HashTreeTraverser {
    ListedHashTree newTree;
    LinkedList objects = new LinkedList();

    public TreeCloner() {
        this.newTree = new ListedHashTree();
    }

    public void addNode(Object node, HashTree subTree) {
        if (node instanceof PerThreadClonable) {
            node = ((PerThreadClonable)node).clone();
            this.newTree.add((Collection)this.objects, node);
        } else {
            this.newTree.add((Collection)this.objects, node);
        }
        this.objects.addLast(node);
    }

    public void subtractNode() {
        this.objects.removeLast();
    }

    public ListedHashTree getClonedTree() {
        return this.newTree;
    }

    public void processPath() {
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testCloning() throws Exception {
            ListedHashTree original = new ListedHashTree();
            GenericController controller = new GenericController();
            controller.setName("controller");
            Arguments args = new Arguments();
            args.setName("args");
            original.add((Object)controller, (Object)args);
            TreeCloner cloner = new TreeCloner();
            original.traverse((HashTreeTraverser)cloner);
            ListedHashTree newTree = cloner.getClonedTree();
            Test.assertTrue((original != newTree ? 1 : 0) != 0);
            Assert.assertEquals((int)original.size(), (int)newTree.size());
            Assert.assertEquals((int)original.getTree(original.getArray()[0]).size(), (int)newTree.getTree(newTree.getArray()[0]).size());
            Assert.assertTrue((original.getArray()[0] != newTree.getArray()[0] ? 1 : 0) != 0);
            Assert.assertEquals((Object)((GenericController)original.getArray()[0]).getName(), (Object)((GenericController)newTree.getArray()[0]).getName());
            Assert.assertSame((Object)original.getTree(original.getArray()[0]).getArray()[0], (Object)newTree.getTree(newTree.getArray()[0]).getArray()[0]);
        }
    }
}

