/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.functions.UnknownFunction;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;

public class CompoundFunction
implements Function {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    private JMeterVariables threadVars;
    static Map functions = new HashMap();
    private Map definedValues;
    private boolean hasFunction = false;
    private boolean hasStatics = false;
    private boolean hasUnknowns = false;
    private String staticSubstitution = "";
    private static Perl5Util util = new Perl5Util();
    private static PatternCompiler compiler = new Perl5Compiler();
    private static String variableSplitter = "/(\\${)/";
    LinkedList compiledComponents = new LinkedList();
    static /* synthetic */ Class class$org$apache$jmeter$functions$Function;

    public CompoundFunction() {
        this.definedValues = new HashMap();
    }

    public String execute(SampleResult previousResult, Sampler currentSampler) {
        if (this.compiledComponents == null || this.compiledComponents.size() == 0) {
            return "";
        }
        StringBuffer results = new StringBuffer();
        Iterator iter = this.compiledComponents.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof Function) {
                try {
                    results.append(((Function)item).execute(previousResult, currentSampler));
                }
                catch (InvalidVariableException e) {}
                continue;
            }
            results.append(item);
        }
        return results.toString();
    }

    public CompoundFunction getFunction() {
        CompoundFunction func = new CompoundFunction();
        func.compiledComponents = (LinkedList)this.compiledComponents.clone();
        return func;
    }

    public List getArgumentDesc() {
        return new LinkedList();
    }

    public void clear() {
        this.hasFunction = false;
        this.hasStatics = false;
        this.compiledComponents.clear();
        this.staticSubstitution = "";
    }

    public void setJMeterVariables(JMeterVariables threadVars) {
        Iterator iter = this.compiledComponents.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof Function)) continue;
            ((Function)item).setJMeterVariables(threadVars);
        }
        this.threadVars = threadVars;
    }

    public void setParameters(String parameters) throws InvalidVariableException {
        if (parameters == null || parameters.length() == 0) {
            return;
        }
        LinkedList components = new LinkedList();
        util.split(components, variableSplitter, parameters);
        Iterator iter = components.iterator();
        String previous = "";
        while (iter.hasNext()) {
            String part = (String)iter.next();
            int index = this.getFunctionEndIndex(part);
            if (index > -1 && previous.equals("${")) {
                String function = part.substring(0, index);
                String functionName = this.parseFunctionName(function);
                if (this.definedValues.containsKey(functionName)) {
                    Object replacement = this.definedValues.get(functionName);
                    if (replacement instanceof Class) {
                        try {
                            this.hasFunction = true;
                            Function func = (Function)((Class)replacement).newInstance();
                            func.setParameters(this.extractParams(function));
                            this.compiledComponents.addLast(func);
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                            throw new InvalidVariableException();
                        }
                    } else {
                        this.hasStatics = true;
                        this.addStringToComponents(this.compiledComponents, (String)replacement);
                    }
                } else {
                    UnknownFunction unknown = new UnknownFunction(functionName);
                    this.compiledComponents.addLast(unknown);
                    this.hasFunction = true;
                    this.hasUnknowns = true;
                }
                if (index + 1 < part.length()) {
                    this.addStringToComponents(this.compiledComponents, part.substring(index + 1));
                }
            } else if (previous.equals("${")) {
                this.addStringToComponents(this.compiledComponents, "${");
                this.addStringToComponents(this.compiledComponents, part);
            } else if (!part.equals("${")) {
                this.addStringToComponents(this.compiledComponents, part);
            }
            previous = part;
        }
        if (!this.hasFunction) {
            this.staticSubstitution = this.compiledComponents.getLast().toString();
            if (this.hasStatics()) {
                this.compiledComponents.clear();
                this.hasStatics = false;
                this.setParameters(this.staticSubstitution);
                this.hasStatics = true;
            }
        } else if (this.hasStatics()) {
            iter = new LinkedList(this.compiledComponents).iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!(item instanceof StringBuffer)) continue;
                CompoundFunction nestedFunc = new CompoundFunction();
                nestedFunc.setUserDefinedVariables(new HashMap());
                nestedFunc.setParameters(item.toString());
                if (!nestedFunc.hasFunction()) continue;
                int index = this.compiledComponents.indexOf(item);
                this.compiledComponents.remove(index);
                this.compiledComponents.add(index, nestedFunc);
            }
        }
    }

    private void addStringToComponents(LinkedList refinedComponents, String part) {
        if (part == null || part.length() == 0) {
            return;
        }
        if (refinedComponents.size() == 0) {
            refinedComponents.addLast(new StringBuffer(part));
        } else if (refinedComponents.getLast() instanceof StringBuffer) {
            ((StringBuffer)refinedComponents.getLast()).append(part);
        } else {
            refinedComponents.addLast(new StringBuffer(part));
        }
    }

    private String extractParams(String function) {
        if (function.indexOf("(") > -1) {
            return function.substring(function.indexOf("(") + 1, function.lastIndexOf(")"));
        }
        return "";
    }

    private int getFunctionEndIndex(String part) {
        int index = part.indexOf("}");
        return index;
    }

    private String parseFunctionName(String function) {
        String functionName = function;
        int parenIndex = -1;
        parenIndex = function.indexOf("(");
        if (parenIndex > -1) {
            functionName = function.substring(0, parenIndex);
        }
        return functionName;
    }

    public boolean hasFunction() {
        return this.hasFunction;
    }

    public boolean hasStatics() {
        return this.hasStatics;
    }

    public String getStaticSubstitution() {
        return this.staticSubstitution;
    }

    public void setUserDefinedVariables(Map userVariables) {
        this.definedValues.clear();
        this.definedValues.putAll(functions);
        this.definedValues.putAll(userVariables);
    }

    public String getReferenceKey() {
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            List classes = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{class$org$apache$jmeter$functions$Function == null ? (class$org$apache$jmeter$functions$Function = CompoundFunction.class$("org.apache.jmeter.functions.Function")) : class$org$apache$jmeter$functions$Function}, (boolean)true);
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                Function tempFunc = (Function)Class.forName((String)iter.next()).newInstance();
                functions.put(tempFunc.getReferenceKey(), tempFunc.getClass());
            }
        }
        catch (Exception err) {
            log.error("", (Throwable)err);
        }
    }

    public static class Test
    extends TestCase {
        CompoundFunction function;
        SampleResult result;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            HashMap<String, String> userDefinedVariables = new HashMap<String, String>();
            userDefinedVariables.put("my_regex", ".*");
            userDefinedVariables.put("server", "jakarta.apache.org");
            this.function = new CompoundFunction();
            this.function.setUserDefinedVariables(userDefinedVariables);
            this.result = new SampleResult();
            this.result.setResponseData("<html>hello world</html>".getBytes());
        }

        public void testParseExample1() throws Exception {
            this.function.setParameters("${__regexFunction(<html>(.*)</html>,$1$)}");
            this.function.setJMeterVariables(new JMeterVariables());
            Assert.assertEquals((int)1, (int)this.function.compiledComponents.size());
            Assert.assertEquals((Object)"org.apache.jmeter.functions.RegexFunction", (Object)this.function.compiledComponents.getFirst().getClass().getName());
            Assert.assertTrue((boolean)this.function.hasFunction());
            Assert.assertTrue((!this.function.hasStatics() ? 1 : 0) != 0);
            Assert.assertEquals((Object)"hello world", (Object)((Function)this.function.compiledComponents.getFirst()).execute(this.result, null));
            Assert.assertEquals((Object)"hello world", (Object)this.function.execute(this.result, null));
        }

        public void testParseExample2() throws Exception {
            this.function.setParameters("It should say:${${__regexFunction(" + URLEncoder.encode("<html>(.*)</html>") + ",$1$)}}");
            this.function.setJMeterVariables(new JMeterVariables());
            Assert.assertEquals((int)3, (int)this.function.compiledComponents.size());
            Assert.assertEquals((Object)"It should say:${", (Object)this.function.compiledComponents.getFirst().toString());
            Assert.assertTrue((boolean)this.function.hasFunction());
            Assert.assertTrue((!this.function.hasStatics() ? 1 : 0) != 0);
            Assert.assertEquals((Object)"hello world", (Object)((Function)this.function.compiledComponents.get(1)).execute(this.result, null));
            Assert.assertEquals((Object)"}", (Object)this.function.compiledComponents.get(2).toString());
            Assert.assertEquals((Object)"It should say:${hello world}", (Object)this.function.execute(this.result, null));
            Assert.assertEquals((Object)"It should say:${<html>(.*)</html>,$1$}", (Object)this.function.execute(null, null));
        }

        public void testParseExample3() throws Exception {
            this.function.setParameters("${__regexFunction(<html>(.*)</html>,$1$)}${__regexFunction(<html>(.*o)(.*o)(.*)</html>,$1$$3$)}");
            this.function.setJMeterVariables(new JMeterVariables());
            Assert.assertEquals((int)2, (int)this.function.compiledComponents.size());
            Assert.assertTrue((boolean)this.function.hasFunction());
            Assert.assertTrue((!this.function.hasStatics() ? 1 : 0) != 0);
            Assert.assertEquals((Object)"hello world", (Object)((Function)this.function.compiledComponents.get(0)).execute(this.result, null));
            Assert.assertEquals((Object)"hellorld", (Object)((Function)this.function.compiledComponents.get(1)).execute(this.result, null));
            Assert.assertEquals((Object)"hello worldhellorld", (Object)this.function.execute(this.result, null));
            Assert.assertEquals((Object)"<html>(.*)</html>,$1$<html>(.*o)(.*o)(.*)</html>,$1$$3$", (Object)this.function.execute(null, null));
        }

        public void testParseExample4() throws Exception {
            this.function.setParameters("${non-existing function}");
            this.function.setJMeterVariables(new JMeterVariables());
            Assert.assertEquals((int)1, (int)this.function.compiledComponents.size());
            Assert.assertTrue((boolean)this.function.hasFunction());
            Assert.assertTrue((!this.function.hasStatics() ? 1 : 0) != 0);
            Assert.assertEquals((Object)"${non-existing function}", (Object)this.function.execute(this.result, null));
            Assert.assertEquals((Object)"${non-existing function}", (Object)this.function.execute(null, null));
        }

        public void testParseExample6() throws Exception {
            this.function.setParameters("${server}");
            this.function.setJMeterVariables(new JMeterVariables());
            Assert.assertEquals((int)1, (int)this.function.compiledComponents.size());
            Assert.assertTrue((!this.function.hasFunction() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.function.hasStatics());
            Assert.assertEquals((Object)"jakarta.apache.org", (Object)this.function.execute(null, null));
        }

        public void testParseExample5() throws Exception {
            this.function.setParameters("");
            this.function.setJMeterVariables(new JMeterVariables());
            Assert.assertEquals((int)0, (int)this.function.compiledComponents.size());
            Assert.assertTrue((!this.function.hasFunction() ? 1 : 0) != 0);
            Assert.assertTrue((!this.function.hasStatics() ? 1 : 0) != 0);
        }

        public void testNestedExample1() throws Exception {
            this.function.setParameters("${__regexFunction(<html>(${my_regex})</html>,$1$)}${__regexFunction(<html>(.*o)(.*o)(.*)</html>,$1$$3$)}");
            this.function.setJMeterVariables(new JMeterVariables());
            Assert.assertEquals((int)2, (int)this.function.compiledComponents.size());
            Assert.assertTrue((boolean)this.function.hasFunction());
            Assert.assertTrue((boolean)this.function.hasStatics());
            Assert.assertEquals((Object)"hello world", (Object)((Function)this.function.compiledComponents.get(0)).execute(this.result, null));
            Assert.assertEquals((Object)"hellorld", (Object)((Function)this.function.compiledComponents.get(1)).execute(this.result, null));
            Assert.assertEquals((Object)"hello worldhellorld", (Object)this.function.execute(this.result, null));
            Assert.assertEquals((Object)"<html>(.*)</html>,$1$<html>(.*o)(.*o)(.*)</html>,$1$$3$", (Object)this.function.execute(null, null));
        }

        public void testNestedExample2() throws Exception {
            this.function.setParameters("${__regexFunction(<html>(${my_regex})</html>,$1$)}");
            this.function.setJMeterVariables(new JMeterVariables());
            Assert.assertEquals((int)1, (int)this.function.compiledComponents.size());
            Assert.assertEquals((Object)"org.apache.jmeter.functions.RegexFunction", (Object)this.function.compiledComponents.getFirst().getClass().getName());
            Assert.assertTrue((boolean)this.function.hasFunction());
            Assert.assertTrue((boolean)this.function.hasStatics());
            Assert.assertEquals((Object)"hello world", (Object)((Function)this.function.compiledComponents.getFirst()).execute(this.result, null));
            Assert.assertEquals((Object)"hello world", (Object)this.function.execute(this.result, null));
        }
    }
}

