/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;

public class UnknownFunction
implements Function {
    private static final String KEY = "__unknownFunction";
    private Map varMap = new HashMap();
    private String name;

    public UnknownFunction(String name) {
        this.name = name;
    }

    public UnknownFunction() {
        this.name = "";
    }

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String ret = this.getVariables().get(this.name);
        if (ret == null || ret.length() == 0) {
            return "${" + this.name + "}";
        }
        return ret;
    }

    private JMeterVariables getVariables() {
        return (JMeterVariables)this.varMap.get(Thread.currentThread().getName());
    }

    public void setParameters(String parameters) throws InvalidVariableException {
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List getArgumentDesc() {
        return null;
    }

    public void setJMeterVariables(JMeterVariables jmv) {
        this.varMap.put(Thread.currentThread().getName(), jmv);
    }

    static {
        KEY = KEY;
    }
}

