/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.functions.CompoundFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.StringUtilities;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ValueReplacer {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    CompoundFunction masterFunction = new CompoundFunction();
    Map variables = new HashMap();

    public ValueReplacer() {
    }

    public ValueReplacer(Map variables) {
        this.setUserDefinedVariables(variables);
    }

    public void setUserDefinedVariables(Map variables) {
        this.masterFunction.setUserDefinedVariables(variables);
        this.variables = variables;
    }

    public void replaceValues(TestElement el) throws InvalidVariableException {
        Iterator iter = el.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            Object propValue = el.getProperty(propName);
            if (propValue instanceof String) {
                Object newValue = this.getNewValue((String)propValue);
                el.setProperty(propName, newValue);
                continue;
            }
            if (propValue instanceof TestElement) {
                this.replaceValues((TestElement)propValue);
                continue;
            }
            if (!(propValue instanceof Collection)) continue;
            el.setProperty(propName, this.replaceValues((Collection)propValue));
        }
    }

    private Object getNewValue(String propValue) throws InvalidVariableException {
        Object newValue = propValue;
        this.masterFunction.clear();
        this.masterFunction.setParameters(propValue);
        if (this.masterFunction.hasFunction()) {
            newValue = this.masterFunction.getFunction();
        } else if (this.masterFunction.hasStatics()) {
            newValue = this.masterFunction.getStaticSubstitution();
        }
        return newValue;
    }

    public Collection replaceValues(Collection values) throws InvalidVariableException {
        Collection newColl = null;
        try {
            newColl = (Collection)values.getClass().newInstance();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return values;
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            if (val instanceof TestElement) {
                this.replaceValues((TestElement)val);
            } else if (val instanceof String) {
                val = this.getNewValue((String)val);
            } else if (val instanceof Collection) {
                val = this.replaceValues((Collection)val);
            }
            newColl.add(val);
        }
        return newColl;
    }

    public Collection reverseReplace(Collection values) {
        Collection newColl = null;
        try {
            newColl = (Collection)values.getClass().newInstance();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return values;
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            if (val instanceof TestElement) {
                this.reverseReplace((TestElement)val);
            } else if (val instanceof String) {
                val = this.substituteValues((String)val);
            } else if (val instanceof Collection) {
                val = this.reverseReplace((Collection)val);
            }
            newColl.add(val);
        }
        return newColl;
    }

    public void reverseReplace(TestElement el) {
        Iterator iter = el.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            Object propValue = el.getProperty(propName);
            if (propValue instanceof String) {
                String newValue = this.substituteValues((String)propValue);
                el.setProperty(propName, newValue);
                continue;
            }
            if (propValue instanceof TestElement) {
                this.reverseReplace((TestElement)propValue);
                continue;
            }
            if (!(propValue instanceof Collection)) continue;
            el.setProperty(propName, this.reverseReplace((Collection)propValue));
        }
    }

    private String substituteValues(String input) {
        Iterator iter = this.variables.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this.variables.get(key);
            input = StringUtilities.substitute(input, value, "${" + key + "}");
        }
        return input;
    }

    public static class Test
    extends TestCase {
        Map variables;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.variables = new HashMap();
            this.variables.put("server", "jakarta.apache.org");
            this.variables.put("username", "jack");
            this.variables.put("password", "jacks_password");
            this.variables.put("regex", ".*");
        }

        public void testReverseReplacement() throws Exception {
            ValueReplacer replacer = new ValueReplacer(this.variables);
            TestPlan element = new TestPlan();
            element.setProperty("domain", "jakarta.apache.org");
            LinkedList<String> args = new LinkedList<String>();
            args.add("username is jack");
            args.add("jacks_password");
            element.setProperty("args", args);
            replacer.reverseReplace(element);
            Assert.assertEquals((Object)"${server}", (Object)element.getProperty("domain"));
        }
    }
}

