/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.jmeter.gui.JMeterGUIComponent;

public class GUIFactory {
    private static final Map guiMap = new HashMap();
    private static final Map iconMap = new HashMap();

    public static ImageIcon getIcon(Class elementClass) {
        String key = elementClass.getName();
        ImageIcon icon = (ImageIcon)iconMap.get(key);
        if (icon != null) {
            return icon;
        }
        if (elementClass.getSuperclass() != null) {
            return GUIFactory.getIcon(elementClass.getSuperclass());
        }
        return null;
    }

    public static JComponent getGUI(Class elementClass) {
        String key = elementClass.getName();
        JComponent gui = (JComponent)guiMap.get(key);
        if (gui != null) {
            return gui;
        }
        if (elementClass.getSuperclass() != null) {
            return GUIFactory.getGUI(elementClass.getSuperclass());
        }
        return null;
    }

    public static void registerIcon(String key, ImageIcon icon) {
        iconMap.put(key, icon);
    }

    public static void registerGUI(String key, Class guiClass) throws InstantiationException, IllegalAccessException {
        JMeterGUIComponent gui = (JMeterGUIComponent)guiClass.newInstance();
        JComponent component = (JComponent)((Object)gui);
        guiMap.put(key, gui);
    }
}

