/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.GlobalMouseListener;
import org.apache.jmeter.gui.tree.JMeterCellRenderer;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MainFrame
extends JFrame
implements TestListener,
Remoteable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    JPanel all;
    JPanel mainPanel;
    Box toolPanel;
    JScrollPane treePanel;
    JMeterMenuBar menuBar;
    JTree tree;
    TreeModel treeModel;
    ActionListener actionHandler;
    JMeterTreeListener treeListener;
    ImageIcon runningIcon = JMeterUtils.getImage("thread.enabled.gif");
    ImageIcon stoppedIcon = JMeterUtils.getImage("thread.disabled.gif");
    JButton runningIndicator;
    private boolean running;
    int previousDragXLocation = 0;
    int previousDragYLocation = 0;
    private Set hosts = new HashSet();
    JDialog stoppingMessage;

    public MainFrame(ActionListener actionHandler, TreeModel treeModel, JMeterTreeListener treeListener) {
        this.runningIndicator = new JButton(this.stoppedIcon);
        this.runningIndicator.setMargin(new Insets(0, 0, 0, 0));
        this.runningIndicator.setBorder(BorderFactory.createEmptyBorder());
        this.treeListener = treeListener;
        this.actionHandler = actionHandler;
        this.treeModel = treeModel;
        GuiPackage.getInstance().setMainFrame(this);
        this.init();
        this.setDefaultCloseOperation(0);
    }

    public MainFrame() {
    }

    public void setFileSaveEnabled(boolean enabled) {
        this.menuBar.setFileSaveEnabled(enabled);
    }

    public void showStoppingMessage(String host) {
        this.stoppingMessage = new JDialog(this, JMeterUtils.getResString("stopping_test_title"), true);
        JLabel stopLabel = new JLabel(JMeterUtils.getResString("stopping_test") + ": " + host);
        stopLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.stoppingMessage.getContentPane().add(stopLabel);
        this.stoppingMessage.pack();
        ComponentUtil.centerComponentInComponent((Component)this, (Component)this.stoppingMessage);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MainFrame.this.stoppingMessage != null) {
                    MainFrame.this.stoppingMessage.show();
                }
            }
        });
    }

    public void setFileLoadEnabled(boolean enabled) {
        this.menuBar.setFileLoadEnabled(enabled);
    }

    public void setEditAddMenu(JMenu menu) {
        this.menuBar.setEditAddMenu(menu);
    }

    public void setEditMenu(JPopupMenu menu) {
        this.menuBar.setEditMenu(menu);
    }

    public void setEditAddEnabled(boolean enabled) {
        this.menuBar.setEditAddEnabled(enabled);
    }

    public void setEditRemoveEnabled(boolean enabled) {
        this.menuBar.setEditRemoveEnabled(enabled);
    }

    public void setEditEnabled(boolean enabled) {
        this.menuBar.setEditEnabled(enabled);
    }

    public void closeMenu() {
        MenuElement[] menuElement;
        if (this.menuBar.isSelected() && (menuElement = this.menuBar.getSubElements()) != null) {
            int i = 0;
            while (i < menuElement.length) {
                JMenu menu = (JMenu)menuElement[i];
                if (menu.isSelected()) {
                    menu.setPopupMenuVisible(false);
                    menu.setSelected(false);
                    break;
                }
                ++i;
            }
        }
    }

    public void setMainPanel(JComponent comp) {
        this.mainPanel.removeAll();
        Rectangle rect = this.mainPanel.getVisibleRect();
        Insets in = this.mainPanel.getInsets();
        Dimension dim = new Dimension((int)rect.getWidth() - (in.right + in.left) * 2, (int)rect.getHeight() - (in.top + in.bottom) * 2);
        Dimension min = comp.getMinimumSize();
        if (dim.width < min.width) {
            dim.width = min.width;
        }
        if (dim.height < min.height) {
            dim.height = min.height;
        }
        comp.setPreferredSize(dim);
        comp.validate();
        this.mainPanel.add(comp);
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void testStarted(String host) {
        this.hosts.add(host);
        this.runningIndicator.setIcon(this.runningIcon);
        this.menuBar.setRunning(true, host);
    }

    public void testStarted() {
        this.testStarted("local");
        this.menuBar.setEnabled(true);
    }

    public void testEnded() {
        this.testEnded("local");
        this.menuBar.setEnabled(false);
        if (this.stoppingMessage != null) {
            this.stoppingMessage.dispose();
            this.stoppingMessage = null;
        }
    }

    public void testEnded(String host) {
        this.hosts.remove(host);
        if (this.hosts.size() == 0) {
            this.runningIndicator.setIcon(this.stoppedIcon);
        }
        this.menuBar.setRunning(false, host);
        if (this.stoppingMessage != null) {
            this.stoppingMessage.dispose();
            this.stoppingMessage = null;
        }
    }

    private void init() {
        this.menuBar = new JMeterMenuBar();
        this.createToolBar();
        this.createMainPanel();
        this.createTreePanel();
        this.addThemAll();
        this.addWindowListener(new WindowHappenings());
        this.tree.setSelectionRow(1);
        this.addMouseListener(new GlobalMouseListener());
    }

    private TreeCellRenderer getCellRenderer() {
        JMeterCellRenderer rend = new JMeterCellRenderer();
        rend.setFont(new Font("Dialog", 0, 11));
        return rend;
    }

    private void addThemAll() {
        this.setJMenuBar(this.menuBar);
        this.all = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.all.add((Component)this.toolPanel, gbc.clone());
        JSplitPane treeAndMain = new JSplitPane(1);
        treeAndMain.setLeftComponent(this.treePanel);
        treeAndMain.setRightComponent(new JScrollPane(this.mainPanel));
        treeAndMain.setContinuousLayout(true);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        this.all.add((Component)treeAndMain, gbc.clone());
        this.getContentPane().add(this.all);
    }

    private void createToolBar() {
        this.toolPanel = new Box(0);
        this.toolPanel.add(Box.createRigidArea(new Dimension(10, 15)));
        this.toolPanel.add(Box.createGlue());
        this.toolPanel.add(this.runningIndicator);
    }

    private void createTreePanel() {
        this.treePanel = new JScrollPane(this.makeTree());
        this.treePanel.setMinimumSize(new Dimension(100, 0));
    }

    public void drawDraggedComponent(Component dragIcon, int x, int y) {
        Dimension size = dragIcon.getPreferredSize();
        this.treePanel.paintImmediately(this.previousDragXLocation, this.previousDragYLocation, size.width, size.height);
        this.getLayeredPane().setLayer(dragIcon, 400);
        SwingUtilities.paintComponent(this.treePanel.getGraphics(), dragIcon, this.treePanel, x, y, size.width, size.height);
        this.previousDragXLocation = x;
        this.previousDragYLocation = y;
    }

    private void createMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout(1, 1));
        this.mainPanel.add(Box.createGlue());
    }

    private JTree makeTree() {
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(this.getCellRenderer());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.treeListener.setJTree(this.tree);
        this.tree.addTreeSelectionListener(this.treeListener);
        this.tree.addMouseListener(this.treeListener);
        this.tree.addMouseMotionListener(this.treeListener);
        this.tree.addKeyListener(this.treeListener);
        return this.tree;
    }

    private class WindowHappenings
    extends WindowAdapter {
        private WindowHappenings() {
        }

        public void windowClosing(WindowEvent event) {
            ActionRouter.getInstance().actionPerformed(new ActionEvent(this, event.getID(), "exit"));
        }
    }
}

