/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;

public class AboutCommand
implements Command {
    private static Set commandSet;
    private static JDialog about;

    public void doAction(ActionEvent e) {
        if (e.getActionCommand().equals("about")) {
            this.about();
        }
    }

    public Set getActionNames() {
        return commandSet;
    }

    void about() {
        MainFrame mainFrame = GuiPackage.getInstance().getMainFrame();
        if (about == null) {
            about = new JDialog(mainFrame, "About Apache JMeter...", false);
            about.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    about.setVisible(false);
                }
            });
            JLabel jmeter = new JLabel(JMeterUtils.getImage("jmeter.jpg"));
            JLabel copyright = new JLabel("Copyright (c) 1998-2002 The Apache Software Foundation", 0);
            JLabel rights = new JLabel("All Rights Reserved.", 0);
            JLabel version = new JLabel("Apache JMeter Version " + JMeterUtils.getJMeterVersion(), 0);
            JPanel infos = new JPanel();
            infos.setOpaque(false);
            infos.setLayout(new GridLayout(0, 1));
            infos.setBorder(new EmptyBorder(5, 5, 5, 5));
            infos.add(copyright);
            infos.add(rights);
            infos.add(version);
            Container panel = about.getContentPane();
            panel.setLayout(new BorderLayout());
            panel.setBackground(Color.white);
            panel.add((Component)jmeter, "North");
            panel.add((Component)infos, "South");
        }
        Point p = mainFrame.getLocationOnScreen();
        Dimension d1 = mainFrame.getSize();
        Dimension d2 = about.getSize();
        about.setLocation(p.x + (d1.width - d2.width) / 2, p.y + (d1.height - d2.height) / 2);
        about.pack();
        about.setVisible(true);
    }

    static {
        HashSet<String> commands = new HashSet<String>();
        commands.add("about");
        commandSet = Collections.unmodifiableSet(commands);
    }
}

