/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.gui.action.AddToTree;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ActionRouter
implements ActionListener {
    private Map commands = new HashMap();
    private static ActionRouter router;
    private static AddToTree add;
    private static transient Logger log;

    private ActionRouter() {
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Set commandObjects = (Set)this.commands.get(e.getActionCommand());
            Iterator iter = commandObjects.iterator();
            while (iter.hasNext()) {
                try {
                    ((Command)iter.next()).doAction(e);
                }
                catch (Exception err) {
                    log.error("", (Throwable)err);
                }
            }
        }
        catch (NullPointerException er) {
            log.error("", (Throwable)er);
            JMeterUtils.reportErrorToUser("Sorry, this feature (" + e.getActionCommand() + ") not yet implemented");
        }
    }

    public Set getAction(String actionName) {
        HashSet set = new HashSet();
        Set commandObjects = (Set)this.commands.get(actionName);
        Iterator iter = commandObjects.iterator();
        while (iter.hasNext()) {
            try {
                set.add(iter.next());
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
        return set;
    }

    public Command getAction(String actionName, String className) {
        Set commandObjects = (Set)this.commands.get(actionName);
        Iterator iter = commandObjects.iterator();
        while (iter.hasNext()) {
            try {
                Command com = (Command)iter.next();
                if (!com.getClass().getName().equals(className)) continue;
                return com;
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
        return null;
    }

    private void populateCommandMap() {
        try {
            List listClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{Class.forName("org.apache.jmeter.gui.action.Command")});
            this.commands = new HashMap(listClasses.size());
            if (listClasses.size() == 0) {
                log.warn("!!!!!Uh-oh, didn't find any action handlers!!!!!");
            }
            Iterator iterClasses = listClasses.iterator();
            while (iterClasses.hasNext()) {
                String strClassName = (String)iterClasses.next();
                Class<?> commandClass = Class.forName(strClassName);
                if (Modifier.isAbstract(commandClass.getModifiers())) continue;
                Command command = (Command)commandClass.newInstance();
                Iterator iter = command.getActionNames().iterator();
                while (iter.hasNext()) {
                    String commandName = (String)iter.next();
                    HashSet<Command> commandObjects = (HashSet<Command>)this.commands.get(commandName);
                    if (commandObjects == null) {
                        commandObjects = new HashSet<Command>();
                        this.commands.put(commandName, commandObjects);
                    }
                    commandObjects.add(command);
                }
            }
        }
        catch (Exception e) {
            log.error("exception finding action handlers", (Throwable)e);
        }
    }

    public static ActionRouter getInstance() {
        if (router == null) {
            router = new ActionRouter();
            router.populateCommandMap();
        }
        return router;
    }

    static {
        add = new AddToTree();
        log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    }
}

