/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AddParent
implements Command {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    private static Set commands = new HashSet();

    public void doAction(ActionEvent e) {
        String name = ((Component)e.getSource()).getName();
        try {
            JMeterGUIComponent controller = (JMeterGUIComponent)Class.forName(name).newInstance();
            this.addParentToTree(controller);
        }
        catch (Exception err) {
            log.error("", (Throwable)err);
        }
    }

    public Set getActionNames() {
        return commands;
    }

    protected void addParentToTree(JMeterGUIComponent newParent) {
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeNode newNode = new JMeterTreeNode(newParent, guiPackage.getTreeModel());
        JMeterTreeNode currentNode = guiPackage.getTreeListener().getCurrentNode();
        JMeterTreeNode parentNode = (JMeterTreeNode)currentNode.getParent();
        int index = parentNode.getIndex(currentNode);
        guiPackage.getTreeModel().removeNodeFromParent(currentNode);
        guiPackage.getTreeModel().insertNodeInto(newNode, parentNode, index);
        guiPackage.getTreeModel().insertNodeInto(currentNode, newNode, newNode.getChildCount());
    }

    static {
        commands.add("Add Parent");
    }
}

