/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;

public class CheckDirty
extends AbstractAction
implements HashTreeTraverser {
    private Map previousGuiItems = new HashMap();
    public static final String CHECK_DIRTY = "check_dirty";
    public static final String SUB_TREE_SAVED = "sub_tree_saved";
    public static final String SUB_TREE_LOADED = "sub_tree_loaded";
    public static final String ADD_ALL = "add_all";
    public static final String SAVE = "save_as";
    public static final String SAVE_ALL = "save_all";
    public static final String SAVE_TO_PREVIOUS = "save";
    public static final String REMOVE = "check_remove";
    boolean checkMode = false;
    boolean removeMode = false;
    boolean dirty = false;
    private static Set commands;

    public void doAction(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(SUB_TREE_SAVED) || action.equals(SAVE)) {
            HashTree subTree = GuiPackage.getInstance().getCurrentSubTree();
            subTree.traverse((HashTreeTraverser)this);
        } else if (action.equals(SAVE_ALL) || action.equals(SAVE_TO_PREVIOUS)) {
            HashTree subTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
            subTree.traverse((HashTreeTraverser)this);
        } else if (action.equals(SUB_TREE_LOADED)) {
            ListedHashTree addTree = (ListedHashTree)e.getSource();
            addTree.traverse((HashTreeTraverser)this);
        } else if (action.equals(ADD_ALL)) {
            this.previousGuiItems.clear();
            GuiPackage.getInstance().getTreeModel().getTestPlan().traverse((HashTreeTraverser)this);
        } else if (action.equals(REMOVE)) {
            GuiPackage guiPackage = GuiPackage.getInstance();
            JMeterTreeNode[] nodes = guiPackage.getTreeListener().getSelectedNodes();
            this.removeMode = true;
            int i = nodes.length - 1;
            while (i >= 0) {
                guiPackage.getTreeModel().getCurrentSubTree(nodes[i]).traverse((HashTreeTraverser)this);
                --i;
            }
            this.removeMode = false;
        } else if (action.equals(CHECK_DIRTY)) {
            this.checkMode = true;
            this.dirty = false;
            HashTree wholeTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
            wholeTree.traverse((HashTreeTraverser)this);
            GuiPackage.getInstance().setDirty(this.dirty);
            this.checkMode = false;
        }
    }

    public void addNode(Object node, HashTree subTree) {
        JMeterGUIComponent treeNode = (JMeterGUIComponent)node;
        if (this.checkMode) {
            if (this.previousGuiItems.containsKey(treeNode)) {
                if (!this.previousGuiItems.get(treeNode).equals(treeNode.createTestElement())) {
                    this.dirty = true;
                }
            } else {
                this.dirty = true;
            }
        } else if (this.removeMode) {
            this.previousGuiItems.remove(treeNode);
        } else {
            this.previousGuiItems.put(treeNode, treeNode.createTestElement());
        }
    }

    public void subtractNode() {
    }

    public void processPath() {
    }

    public Set getActionNames() {
        return commands;
    }

    static {
        CHECK_DIRTY = CHECK_DIRTY;
        SUB_TREE_SAVED = SUB_TREE_SAVED;
        SUB_TREE_LOADED = SUB_TREE_LOADED;
        ADD_ALL = ADD_ALL;
        SAVE = SAVE;
        SAVE_ALL = SAVE_ALL;
        SAVE_TO_PREVIOUS = SAVE_TO_PREVIOUS;
        REMOVE = REMOVE;
        commands = new HashSet();
        commands.add(CHECK_DIRTY);
        commands.add(SUB_TREE_SAVED);
        commands.add(SUB_TREE_LOADED);
        commands.add(ADD_ALL);
        commands.add(SAVE);
        commands.add(SAVE_ALL);
        commands.add(REMOVE);
        commands.add(SAVE_TO_PREVIOUS);
    }
}

