/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;

public class DragNDrop
extends AbstractAction {
    public static final String ADD = "drag_n_drop.add";
    public static final String INSERT_BEFORE = "drag_n_drop.insert_before";
    public static final String INSERT_AFTER = "drag_n_drop.insert_after";
    private static Set commands;

    public void doAction(ActionEvent e) {
        String action = e.getActionCommand();
        JMeterTreeNode draggedNode = GuiPackage.getInstance().getTreeListener().getDraggedNode();
        JMeterTreeListener treeListener = GuiPackage.getInstance().getTreeListener();
        JMeterTreeNode currentNode = treeListener.getCurrentNode();
        GuiPackage.getInstance().getTreeModel().removeNodeFromParent(GuiPackage.getInstance().getTreeListener().getDraggedNode());
        if (ADD.equals(action)) {
            GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNode, currentNode, currentNode.getChildCount());
        } else if (INSERT_BEFORE.equals(action)) {
            JMeterTreeNode parentNode = (JMeterTreeNode)currentNode.getParent();
            int index = parentNode.getIndex(currentNode);
            GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNode, parentNode, index);
        } else if (INSERT_AFTER.equals(action)) {
            JMeterTreeNode parentNode = (JMeterTreeNode)currentNode.getParent();
            int index = parentNode.getIndex(currentNode) + 1;
            GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNode, parentNode, index);
        }
        GuiPackage.getInstance().getMainFrame().repaint();
    }

    public Set getActionNames() {
        return commands;
    }

    static {
        ADD = ADD;
        INSERT_BEFORE = INSERT_BEFORE;
        INSERT_AFTER = INSERT_AFTER;
        commands = new HashSet();
        commands.add(ADD);
        commands.add(INSERT_BEFORE);
        commands.add(INSERT_AFTER);
    }
}

